/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;

public class WorldGenRoostSpike {
    private final Direction direction;

    public WorldGenRoostSpike(Direction direction) {
        this.direction = direction;
    }

    public boolean generate(LevelAccessor worldIn, Random rand, BlockPos position) {
        int radius = 5;
        for (int i = 0; i < 5; ++i) {
            int j = Math.max(0, radius - (int)((float)i * 1.75f));
            int l = radius - i;
            int k = Math.max(0, radius - (int)((float)i * 1.5f));
            float f = (float)(j + l) * 0.333f + 0.5f;
            BlockPos up = position.m_7494_().m_5484_(this.direction, i);
            int xOrZero = this.direction.m_122434_() == Direction.Axis.Z ? j : 0;
            int zOrZero = this.direction.m_122434_() == Direction.Axis.Z ? 0 : k;
            for (BlockPos blockpos : BlockPos.m_121990_((BlockPos)up.m_142082_(-xOrZero, -l, -zOrZero), (BlockPos)up.m_142082_(xOrZero, l, zOrZero)).map(BlockPos::m_7949_).collect(Collectors.toSet())) {
                if (!(blockpos.m_123331_((Vec3i)position) <= (double)(f * f))) continue;
                int height = Math.max(blockpos.m_123342_() - up.m_123342_(), 0);
                if (i <= 0) {
                    if (!(rand.nextFloat() < (float)height * 0.3f)) continue;
                    worldIn.m_7731_(blockpos, ((Block)IafBlockRegistry.CRACKLED_STONE.get()).m_49966_(), 2);
                    continue;
                }
                worldIn.m_7731_(blockpos, ((Block)IafBlockRegistry.CRACKLED_STONE.get()).m_49966_(), 2);
            }
        }
        return true;
    }
}

