/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world.gen;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.event.WorldGenUtils;
import com.github.alexthe666.iceandfire.world.IafWorldRegistry;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostArch;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostBoulder;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostGoldPile;
import com.github.alexthe666.iceandfire.world.gen.WorldGenRoostPile;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;

public class WorldGenIceDragonRoosts
extends Feature<NoneFeatureConfiguration> {
    private static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST};
    private static boolean isMale;
    public static ResourceLocation DRAGON_CHEST;

    public WorldGenIceDragonRoosts(Codec<NoneFeatureConfiguration> configFactoryIn) {
        super(configFactoryIn);
    }

    private void transformState(LevelAccessor world, BlockPos blockpos, BlockState state) {
        float hardness = state.m_60800_((BlockGetter)world, blockpos);
        if (hardness != -1.0f) {
            if (state.m_60734_() instanceof BaseEntityBlock) {
                return;
            }
            if (state.m_60767_() == Material.f_76315_) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_GRASS.get()).m_49966_(), 2);
            } else if (state.m_60767_() == Material.f_76314_ && state.m_60734_() == Blocks.f_50493_) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_DIRT.get()).m_49966_(), 2);
            } else if (state.m_60767_() == Material.f_76314_ && state.m_60734_() == Blocks.f_49994_) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_GRAVEL.get()).m_49966_(), 2);
            } else if (state.m_60767_() == Material.f_76278_ && (state.m_60734_() == Blocks.f_50652_ || state.m_60734_().m_7705_().contains("cobblestone"))) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_COBBLESTONE.get()).m_49966_(), 2);
            } else if (state.m_60767_() == Material.f_76278_ && state.m_60734_() != IafBlockRegistry.FROZEN_COBBLESTONE.get()) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_STONE.get()).m_49966_(), 2);
            } else if (state.m_60734_() == Blocks.f_152481_) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_DIRT_PATH.get()).m_49966_(), 2);
            } else if (state.m_60767_() == Material.f_76320_) {
                world.m_7731_(blockpos, ((Block)IafBlockRegistry.FROZEN_SPLINTERS.get()).m_49966_(), 2);
            } else if (state.m_60767_() == Material.f_76274_ || state.m_60767_() == Material.f_76300_) {
                world.m_7731_(blockpos, Blocks.f_50016_.m_49966_(), 2);
            }
        }
    }

    public boolean m_142674_(FeaturePlaceContext<NoneFeatureConfiguration> context) {
        WorldGenLevel worldIn = context.m_159774_();
        Random rand = context.m_159776_();
        BlockPos position = context.m_159777_();
        if (!(IafConfig.generateDragonRoosts && rand.nextInt(IafConfig.generateDragonRoostChance) == 0 && IafWorldRegistry.isFarEnoughFromSpawn((LevelAccessor)worldIn, position) && IafWorldRegistry.isFarEnoughFromDangerousGen((ServerLevelAccessor)worldIn, position))) {
            return false;
        }
        if (!worldIn.m_6425_(worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position).m_7495_()).m_76178_()) {
            return false;
        }
        position = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position);
        isMale = new Random().nextBoolean();
        boolean boulders = false;
        int radius = 12 + rand.nextInt(8);
        BlockPos finalPosition = position;
        EntityDragonBase dragon = (EntityDragonBase)((EntityType)IafEntityRegistry.ICE_DRAGON.get()).m_20615_((Level)worldIn.m_6018_());
        dragon.setGender(isMale);
        dragon.growDragon(40 + radius);
        dragon.setAgingDisabled(true);
        dragon.m_21153_(dragon.m_21233_());
        dragon.setVariant(new Random().nextInt(4));
        dragon.m_19890_((double)position.m_123341_() + 0.5, (double)worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, position).m_123342_() + 1.5, (double)position.m_123343_() + 0.5, rand.nextFloat() * 360.0f, 0.0f);
        dragon.homePos = new HomePosition(position, (Level)worldIn.m_6018_());
        dragon.hasHomePosition = true;
        dragon.setHunger(50);
        worldIn.m_7967_((Entity)dragon);
        int j = radius;
        int k = 2;
        int l = radius;
        float f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos.m_121990_((BlockPos)position.m_142082_(-j, k, -l), (BlockPos)position.m_142082_(j, 0, l)).map(BlockPos::m_7949_).forEach(blockPos -> {
            int yAdd = blockPos.m_123342_() - finalPosition.m_123342_();
            if (blockPos.m_123331_((Vec3i)finalPosition) <= (double)(f * f) && yAdd < 2 + rand.nextInt(k) && !worldIn.m_46859_(blockPos.m_7495_())) {
                if (worldIn.m_46859_(blockPos.m_7494_())) {
                    worldIn.m_7731_(blockPos, ((Block)IafBlockRegistry.FROZEN_GRASS.get()).m_49966_(), 2);
                } else {
                    worldIn.m_7731_(blockPos, ((Block)IafBlockRegistry.FROZEN_DIRT.get()).m_49966_(), 2);
                }
            }
        });
        j = radius;
        k = radius / 5;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, 1, l)).map(BlockPos::m_7949_).forEach(blockPos -> {
            if (blockPos.m_123331_((Vec3i)finalPosition) < (double)(f * f)) {
                worldIn.m_7731_(blockPos, rand.nextBoolean() ? ((Block)IafBlockRegistry.FROZEN_GRAVEL.get()).m_49966_() : ((Block)IafBlockRegistry.FROZEN_DIRT.get()).m_49966_(), 2);
            } else if (blockPos.m_123331_((Vec3i)finalPosition) == (double)(f * f)) {
                worldIn.m_7731_(blockPos, ((Block)IafBlockRegistry.FROZEN_COBBLESTONE.get()).m_49966_(), 2);
            }
        });
        j = radius -= 2;
        k = 2;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos up = position.m_6630_(k - 1);
        BlockPos.m_121990_((BlockPos)up.m_142082_(-j, -k + 2, -l), (BlockPos)up.m_142082_(j, k, l)).map(BlockPos::m_7949_).forEach(blockPos -> {
            if (blockPos.m_123331_((Vec3i)finalPosition) <= (double)(f * f)) {
                worldIn.m_7731_(blockPos, Blocks.f_50016_.m_49966_(), 2);
            }
        });
        j = radius += 15;
        k = radius / 5;
        l = radius;
        f = (float)(j + k + l) * 0.333f + 0.5f;
        BlockPos.m_121990_((BlockPos)position.m_142082_(-j, -k, -l), (BlockPos)position.m_142082_(j, k, l)).map(BlockPos::m_7949_).forEach(blockPos -> {
            if (blockPos.m_123331_((Vec3i)finalPosition) <= (double)(f * f)) {
                BlockPos height;
                double dist = blockPos.m_123331_((Vec3i)finalPosition) / (double)(f * f);
                if (!worldIn.m_46859_(finalPosition) && rand.nextDouble() > dist * 0.5) {
                    this.transformState((LevelAccessor)worldIn, (BlockPos)blockPos, worldIn.m_8055_(blockPos));
                }
                if (dist > 0.5 && rand.nextInt(1000) == 0) {
                    height = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, blockPos);
                    new WorldGenRoostBoulder((Block)IafBlockRegistry.FROZEN_COBBLESTONE.get(), rand.nextInt(3), true).generate((LevelAccessor)worldIn, rand, height);
                }
                if (rand.nextInt(1000) == 0) {
                    height = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, blockPos);
                    new WorldGenRoostPile((Block)IafBlockRegistry.DRAGON_ICE.get()).generate((LevelAccessor)worldIn, rand, height);
                }
                if (dist < 0.3 && rand.nextInt(isMale ? 200 : 300) == 0) {
                    height = WorldGenUtils.degradeSurface((LevelAccessor)worldIn, worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, blockPos)).m_7494_();
                    new WorldGenRoostGoldPile((Block)IafBlockRegistry.SILVER_PILE.get()).generate((LevelAccessor)worldIn, rand, height);
                }
                if (dist < 0.3 && rand.nextInt(isMale ? 500 : 700) == 0) {
                    BlockEntity tileentity1;
                    height = WorldGenUtils.degradeSurface((LevelAccessor)worldIn, worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, blockPos)).m_7494_();
                    worldIn.m_7731_(height, (BlockState)Blocks.f_50087_.m_49966_().m_61124_((Property)ChestBlock.f_51478_, (Comparable)HORIZONTALS[new Random().nextInt(3)]), 2);
                    if (worldIn.m_8055_(height).m_60734_() instanceof ChestBlock && (tileentity1 = worldIn.m_7702_(height)) instanceof ChestBlockEntity) {
                        ((ChestBlockEntity)tileentity1).m_59626_(DRAGON_CHEST, new Random().nextLong());
                    }
                }
                if (rand.nextInt(5000) == 0) {
                    height = worldIn.m_5452_(Heightmap.Types.WORLD_SURFACE_WG, blockPos);
                    new WorldGenRoostArch((Block)IafBlockRegistry.FROZEN_COBBLESTONE.get()).generate((LevelAccessor)worldIn, rand, height);
                }
            }
        });
        return true;
    }

    static {
        DRAGON_CHEST = new ResourceLocation("iceandfire", "chest/ice_dragon_roost");
    }
}

