/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.world;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.config.BiomeConfig;
import com.github.alexthe666.iceandfire.config.biome.IafSpawnBiomeData;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.world.IafWorldData;
import com.github.alexthe666.iceandfire.world.feature.SpawnDeathWorm;
import com.github.alexthe666.iceandfire.world.feature.SpawnDragonSkeleton;
import com.github.alexthe666.iceandfire.world.feature.SpawnHippocampus;
import com.github.alexthe666.iceandfire.world.feature.SpawnSeaSerpent;
import com.github.alexthe666.iceandfire.world.feature.SpawnStymphalianBird;
import com.github.alexthe666.iceandfire.world.feature.SpawnWanderingCyclops;
import com.github.alexthe666.iceandfire.world.gen.WorldGenCyclopsCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenFireDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenHydraCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenIceDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonCave;
import com.github.alexthe666.iceandfire.world.gen.WorldGenLightningDragonRoosts;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.github.alexthe666.iceandfire.world.gen.WorldGenPixieVillage;
import com.github.alexthe666.iceandfire.world.gen.WorldGenSirenIsland;
import com.github.alexthe666.iceandfire.world.structure.DreadMausoleumStructure;
import com.github.alexthe666.iceandfire.world.structure.DummyPiece;
import com.github.alexthe666.iceandfire.world.structure.GorgonTempleStructure;
import com.github.alexthe666.iceandfire.world.structure.GraveyardStructure;
import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.data.worldgen.PlainVillagePools;
import net.minecraft.data.worldgen.features.FeatureUtils;
import net.minecraft.data.worldgen.features.OreFeatures;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.RandomPatchConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.ReplaceBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleBlockConfiguration;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountPlacement;
import net.minecraft.world.level.levelgen.placement.HeightRangePlacement;
import net.minecraft.world.level.levelgen.placement.InSquarePlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.StructureSet;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadStructurePlacement;
import net.minecraft.world.level.levelgen.structure.placement.RandomSpreadType;
import net.minecraft.world.level.levelgen.structure.placement.StructurePlacement;
import net.minecraft.world.level.storage.LevelData;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.commons.lang3.tuple.Pair;

public class IafWorldRegistry {
    public static final DeferredRegister<Feature<?>> FEATURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.FEATURES, (String)"iceandfire");
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"iceandfire");
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FIRE_DRAGON_ROOST;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ICE_DRAGON_ROOST;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> LIGHTNING_DRAGON_ROOST;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> FIRE_DRAGON_CAVE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> ICE_DRAGON_CAVE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> LIGHTNING_DRAGON_CAVE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> CYCLOPS_CAVE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> PIXIE_VILLAGE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SIREN_ISLAND;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> HYDRA_CAVE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MYRMEX_HIVE_DESERT;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> MYRMEX_HIVE_JUNGLE;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DEATH_WORM;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_L;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_F;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_DRAGON_SKELETON_I;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_HIPPOCAMPUS;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_SEA_SERPENT;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_STYMPHALIAN_BIRD;
    public static final RegistryObject<Feature<NoneFeatureConfiguration>> SPAWN_WANDERING_CYCLOPS;
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> GORGON_TEMPLE;
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> MAUSOLEUM;
    public static final RegistryObject<StructureFeature<JigsawConfiguration>> GRAVEYARD;
    public static final TagKey<Biome> HAS_GORGON_TEMPLE;
    public static final TagKey<Biome> HAS_MAUSOLEUM;
    public static final TagKey<Biome> HAS_GRAVEYARD;
    public static final ResourceLocation RL_IAF_STRUCTURE_SET;
    public static final TagKey<StructureSet> IAF_STRUCTURE_SET;
    public static StructurePieceType DUMMY_PIECE;
    public static Holder<PlacedFeature> FIRE_LILY_CF;
    public static Holder<PlacedFeature> FROST_LILY_CF;
    public static Holder<PlacedFeature> LIGHTNING_LILY_CF;
    public static Holder<PlacedFeature> COPPER_ORE_CF;
    public static Holder<PlacedFeature> SILVER_ORE_CF;
    public static Holder<PlacedFeature> SAPPHIRE_ORE_CF;
    public static Holder<PlacedFeature> AMETHYST_ORE_CF;
    public static Holder<PlacedFeature> FIRE_DRAGON_ROOST_CF;
    public static Holder<PlacedFeature> ICE_DRAGON_ROOST_CF;
    public static Holder<PlacedFeature> LIGHTNING_DRAGON_ROOST_CF;
    public static Holder<PlacedFeature> FIRE_DRAGON_CAVE_CF;
    public static Holder<PlacedFeature> ICE_DRAGON_CAVE_CF;
    public static Holder<PlacedFeature> LIGHTNING_DRAGON_CAVE_CF;
    public static Holder<PlacedFeature> CYCLOPS_CAVE_CF;
    public static Holder<PlacedFeature> PIXIE_VILLAGE_CF;
    public static Holder<PlacedFeature> SIREN_ISLAND_CF;
    public static Holder<PlacedFeature> HYDRA_CAVE_CF;
    public static Holder<PlacedFeature> MYRMEX_HIVE_DESERT_CF;
    public static Holder<PlacedFeature> MYRMEX_HIVE_JUNGLE_CF;
    public static Holder<PlacedFeature> SPAWN_DEATH_WORM_CF;
    public static Holder<PlacedFeature> SPAWN_DRAGON_SKELETON_L_CF;
    public static Holder<PlacedFeature> SPAWN_DRAGON_SKELETON_F_CF;
    public static Holder<PlacedFeature> SPAWN_DRAGON_SKELETON_I_CF;
    public static Holder<PlacedFeature> SPAWN_HIPPOCAMPUS_CF;
    public static Holder<PlacedFeature> SPAWN_SEA_SERPENT_CF;
    public static Holder<PlacedFeature> SPAWN_STYMPHALIAN_BIRD_CF;
    public static Holder<PlacedFeature> SPAWN_WANDERING_CYCLOPS_CF;
    public static Holder<ConfiguredStructureFeature<?, ?>> GORGON_TEMPLE_CF;
    public static Holder<ConfiguredStructureFeature<?, ?>> MAUSOLEUM_CF;
    public static Holder<ConfiguredStructureFeature<?, ?>> GRAVEYARD_CF;
    private static final BiFunction<String, Feature, Holder<PlacedFeature>> registerSimple;
    public static HashMap<String, Boolean> LOADED_FEATURES;
    public static Set<BiomeGenerationSettings> processed;

    private static <C extends FeatureConfiguration, F extends Feature<C>> RegistryObject<F> register(String name, Supplier<? extends F> supplier) {
        return FEATURES.register(name, supplier);
    }

    private static HeightRangePlacement maxHeight(int max) {
        return HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158921_(), (VerticalAnchor)VerticalAnchor.m_158922_((int)max));
    }

    private static HeightRangePlacement minMaxHeight(int min, int max) {
        return HeightRangePlacement.m_191680_((VerticalAnchor)VerticalAnchor.m_158922_((int)min), (VerticalAnchor)VerticalAnchor.m_158922_((int)max));
    }

    private static CountPlacement count(int count) {
        return CountPlacement.m_191628_((int)count);
    }

    private static <C extends FeatureConfiguration, F extends Feature<C>> Holder<PlacedFeature> register(String registerName, ConfiguredFeature<C, F> feature, PlacementModifier ... modifiers) {
        Registry.m_122965_((Registry)BuiltinRegistries.f_123861_, (ResourceLocation)new ResourceLocation(registerName), feature);
        return PlacementUtils.m_206513_((String)registerName, (Holder)Holder.m_205709_(feature), (PlacementModifier[])modifiers);
    }

    public static void registerConfiguredFeatures() {
        DUMMY_PIECE = (StructurePieceType)Registry.m_122961_((Registry)Registry.f_122843_, (String)"iceandfire:gorgon_piece", DummyPiece::new);
        Registry.m_122961_((Registry)Registry.f_122843_, (String)"iceandfire:mausoleum_piece", DummyPiece::new);
        Registry.m_122961_((Registry)Registry.f_122843_, (String)"iceandfire:gorgon_piece_empty", DummyPiece::new);
        Registry.m_122961_((Registry)Registry.f_122843_, (String)"iceandfire:graveyard_piece", DummyPiece::new);
        COPPER_ORE_CF = IafWorldRegistry.register("iceandfire:copper_ore", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(OreFeatures.f_195071_, ((Block)IafBlockRegistry.COPPER_ORE.get()).m_49966_(), 8)), new PlacementModifier[]{CountPlacement.m_191628_((int)2), IafWorldRegistry.maxHeight(128), InSquarePlacement.m_191715_()});
        SILVER_ORE_CF = IafWorldRegistry.register("iceandfire:silver_ore", new ConfiguredFeature(Feature.f_65731_, (FeatureConfiguration)new OreConfiguration(OreFeatures.f_195071_, ((Block)IafBlockRegistry.SILVER_ORE.get()).m_49966_(), 8)), new PlacementModifier[]{CountPlacement.m_191628_((int)2), IafWorldRegistry.maxHeight(32), InSquarePlacement.m_191715_()});
        SAPPHIRE_ORE_CF = IafWorldRegistry.register("iceandfire:sapphire_ore", new ConfiguredFeature(Feature.f_159732_, (FeatureConfiguration)new ReplaceBlockConfiguration(Blocks.f_50069_.m_49966_(), ((Block)IafBlockRegistry.SAPPHIRE_ORE.get()).m_49966_())), new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)3, (int)8))});
        AMETHYST_ORE_CF = IafWorldRegistry.register("%s:amethyst_ore".formatted("iceandfire"), new ConfiguredFeature(Feature.f_159732_, (FeatureConfiguration)new ReplaceBlockConfiguration(Blocks.f_50069_.m_49966_(), ((Block)IafBlockRegistry.AMYTHEST_ORE.get()).m_49966_())), new PlacementModifier[]{CountPlacement.m_191630_((IntProvider)UniformInt.m_146622_((int)3, (int)8))});
        Function<Block, RandomPatchConfiguration> flowerConf = block -> FeatureUtils.m_206470_((int)1, (Holder)PlacementUtils.m_206495_((Feature)Feature.f_65741_, (FeatureConfiguration)new SimpleBlockConfiguration((BlockStateProvider)BlockStateProvider.m_191382_((Block)block.m_49966_().m_60734_()))));
        FIRE_LILY_CF = IafWorldRegistry.register("%s:fire_lily".formatted("iceandfire"), new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)flowerConf.apply((Block)IafBlockRegistry.FIRE_LILY.get())), PlacementUtils.f_195352_);
        FROST_LILY_CF = IafWorldRegistry.register("%s:frost_lily".formatted("iceandfire"), new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)flowerConf.apply((Block)IafBlockRegistry.FROST_LILY.get())), PlacementUtils.f_195352_);
        LIGHTNING_LILY_CF = IafWorldRegistry.register("%s:lightning_lily".formatted("iceandfire"), new ConfiguredFeature(Feature.f_65761_, (FeatureConfiguration)flowerConf.apply((Block)IafBlockRegistry.LIGHTNING_LILY.get())), PlacementUtils.f_195352_);
        FIRE_DRAGON_ROOST_CF = registerSimple.apply("fire_dragon_roost", (Feature)FIRE_DRAGON_ROOST.get());
        ICE_DRAGON_ROOST_CF = registerSimple.apply("ice_dragon_roost", (Feature)ICE_DRAGON_ROOST.get());
        LIGHTNING_DRAGON_ROOST_CF = registerSimple.apply("lightning_dragon_roost", (Feature)LIGHTNING_DRAGON_ROOST.get());
        FIRE_DRAGON_CAVE_CF = registerSimple.apply("fire_dragon_cave", (Feature)FIRE_DRAGON_CAVE.get());
        ICE_DRAGON_CAVE_CF = registerSimple.apply("ice_dragon_cave", (Feature)ICE_DRAGON_CAVE.get());
        LIGHTNING_DRAGON_CAVE_CF = registerSimple.apply("lightning_dragon_cave", (Feature)LIGHTNING_DRAGON_CAVE.get());
        CYCLOPS_CAVE_CF = registerSimple.apply("cyclops_cave", (Feature)CYCLOPS_CAVE.get());
        PIXIE_VILLAGE_CF = registerSimple.apply("pixie_village", (Feature)PIXIE_VILLAGE.get());
        SIREN_ISLAND_CF = registerSimple.apply("siren_island", (Feature)SIREN_ISLAND.get());
        HYDRA_CAVE_CF = registerSimple.apply("hydra_cave", (Feature)HYDRA_CAVE.get());
        MYRMEX_HIVE_DESERT_CF = registerSimple.apply("myrmex_hive_deser", (Feature)MYRMEX_HIVE_DESERT.get());
        MYRMEX_HIVE_JUNGLE_CF = registerSimple.apply("myrmex_hive_jungl", (Feature)MYRMEX_HIVE_JUNGLE.get());
        SPAWN_DEATH_WORM_CF = registerSimple.apply("spawn_death_worm_mis", (Feature)SPAWN_DEATH_WORM.get());
        SPAWN_DRAGON_SKELETON_L_CF = registerSimple.apply("spawn_dragon_skeleton_l_misc", (Feature)SPAWN_DRAGON_SKELETON_L.get());
        SPAWN_DRAGON_SKELETON_F_CF = registerSimple.apply("spawn_dragon_skeleton_f_misc", (Feature)SPAWN_DRAGON_SKELETON_F.get());
        SPAWN_DRAGON_SKELETON_I_CF = registerSimple.apply("spawn_dragon_skeleton_i_misc", (Feature)SPAWN_DRAGON_SKELETON_I.get());
        SPAWN_HIPPOCAMPUS_CF = registerSimple.apply("spawn_hippocampus_misc", (Feature)SPAWN_HIPPOCAMPUS.get());
        SPAWN_SEA_SERPENT_CF = registerSimple.apply("spawn_sea_serpent_misc", (Feature)SPAWN_SEA_SERPENT.get());
        SPAWN_STYMPHALIAN_BIRD_CF = registerSimple.apply("spawn_stymphalian_bird_misc", (Feature)SPAWN_STYMPHALIAN_BIRD.get());
        SPAWN_WANDERING_CYCLOPS_CF = registerSimple.apply("spawn_wandering_cyclops_misc", (Feature)SPAWN_WANDERING_CYCLOPS.get());
    }

    public static void registerStructureSet(Holder<ConfiguredStructureFeature<?, ?>> structure, String name, int spacing, int separation, int seed) {
        BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_211084_, (ResourceLocation)new ResourceLocation("iceandfire", name), (Object)new StructureSet(structure, (StructurePlacement)new RandomSpreadStructurePlacement(spacing, separation, RandomSpreadType.LINEAR, seed)));
    }

    public static Holder<ConfiguredStructureFeature<?, ?>> registerConfiguredStructureFeature(String name, RegistryObject<StructureFeature<JigsawConfiguration>> structure, TagKey<Biome> biomeTag) {
        JigsawConfiguration DUMMY_CONFIG = new JigsawConfiguration(PlainVillagePools.f_127183_, 0);
        return BuiltinRegistries.m_206396_((Registry)BuiltinRegistries.f_123862_, (String)"%s:%s".formatted("iceandfire", name), (Object)((StructureFeature)structure.get()).m_209769_((FeatureConfiguration)DUMMY_CONFIG, biomeTag, false));
    }

    public static void registerStructureConfiguredFeatures() {
        GORGON_TEMPLE_CF = IafWorldRegistry.registerConfiguredStructureFeature("gorgon_temple", GORGON_TEMPLE, HAS_GORGON_TEMPLE);
        MAUSOLEUM_CF = IafWorldRegistry.registerConfiguredStructureFeature("mausoleum", MAUSOLEUM, HAS_MAUSOLEUM);
        GRAVEYARD_CF = IafWorldRegistry.registerConfiguredStructureFeature("graveyard", GRAVEYARD, HAS_GRAVEYARD);
        int average = (int)Math.ceil(IntStream.of(IafConfig.spawnGorgonsChance, IafConfig.generateMausoleumChance, IafConfig.generateGraveyardChance * 3).average().getAsDouble());
        StructureSet structures = new StructureSet(List.of(new StructureSet.StructureSelectionEntry(GRAVEYARD_CF, IafConfig.generateGraveyardChance * 3), new StructureSet.StructureSelectionEntry(MAUSOLEUM_CF, IafConfig.generateMausoleumChance), new StructureSet.StructureSelectionEntry(GORGON_TEMPLE_CF, IafConfig.spawnGorgonsChance)), (StructurePlacement)new RandomSpreadStructurePlacement(Math.max(average, 2), Math.max(average / 2, 1), RandomSpreadType.LINEAR, 342226450));
        BuiltinRegistries.m_206388_((Registry)BuiltinRegistries.f_211084_, (ResourceLocation)new ResourceLocation("iceandfire", "structures"), (Object)structures);
    }

    public static boolean isFarEnoughFromSpawn(LevelAccessor world, BlockPos pos) {
        LevelData spawnPoint = world.m_6106_();
        BlockPos spawnRelative = new BlockPos(spawnPoint.m_6789_(), pos.m_123342_(), spawnPoint.m_6527_());
        boolean spawnCheck = !spawnRelative.m_123314_((Vec3i)pos, IafConfig.dangerousWorldGenDistanceLimit);
        return spawnCheck;
    }

    public static boolean isFarEnoughFromDangerousGen(ServerLevelAccessor world, BlockPos pos) {
        boolean canGen = true;
        IafWorldData data = IafWorldData.get((Level)world.m_6018_());
        if (data != null) {
            BlockPos last = data.lastGeneratedDangerousStructure;
            boolean bl = canGen = last.m_123331_((Vec3i)pos) > IafConfig.dangerousWorldGenSeparationLimit * IafConfig.dangerousWorldGenSeparationLimit;
            if (canGen) {
                data.setLastGeneratedDangerousStructure(pos);
            }
        }
        return canGen;
    }

    public static void addFeatures(Holder<Biome> biomeHolder) {
        if (processed.contains(((Biome)biomeHolder.m_203334_()).m_47536_())) {
            return;
        }
        BiomeGenerationSettingsBuilder generator = new BiomeGenerationSettingsBuilder(((Biome)biomeHolder.m_203334_()).m_47536_());
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireLilyBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, FIRE_LILY_CF);
            LOADED_FEATURES.put("FIRE_LILY_CF", true);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningLilyBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, LIGHTNING_LILY_CF);
            LOADED_FEATURES.put("LIGHTNING_LILY_CF", true);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceLilyBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.VEGETAL_DECORATION, FROST_LILY_CF);
            LOADED_FEATURES.put("FROST_LILY_CF", true);
        }
        if (IafWorldRegistry.safelyTestBiome(BiomeConfig.oreGenBiomes, biomeHolder)) {
            if (IafConfig.generateSilverOre) {
                generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, SILVER_ORE_CF);
                LOADED_FEATURES.put("SILVER_ORE_CF", true);
            }
            if (IafConfig.generateCopperOre) {
                generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, COPPER_ORE_CF);
                LOADED_FEATURES.put("COPPER_ORE_CF", true);
            }
        }
        if (IafConfig.generateSapphireOre && IafWorldRegistry.safelyTestBiome(BiomeConfig.sapphireBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, SAPPHIRE_ORE_CF);
            LOADED_FEATURES.put("SAPPHIRE_ORE_CF", true);
        }
        if (IafConfig.generateAmythestOre && IafWorldRegistry.safelyTestBiome(BiomeConfig.amethystBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_ORES, AMETHYST_ORE_CF);
            LOADED_FEATURES.put("AMETHYST_ORE_CF", true);
        }
        if (IafConfig.generateDragonRoosts) {
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireDragonBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, FIRE_DRAGON_ROOST_CF);
                LOADED_FEATURES.put("FIRE_DRAGON_ROOST_CF", true);
            }
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningDragonBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, LIGHTNING_DRAGON_ROOST_CF);
                LOADED_FEATURES.put("LIGHTNING_DRAGON_ROOST_CF", true);
            }
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceDragonBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, ICE_DRAGON_ROOST_CF);
                LOADED_FEATURES.put("ICE_DRAGON_ROOST_CF", true);
            }
        }
        if (IafConfig.generateDragonDens) {
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireDragonCaveBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, FIRE_DRAGON_CAVE_CF);
                LOADED_FEATURES.put("FIRE_DRAGON_CAVE_CF", true);
            }
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningDragonCaveBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, LIGHTNING_DRAGON_CAVE_CF);
                LOADED_FEATURES.put("LIGHTNING_DRAGON_CAVE_CF", true);
            }
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceDragonCaveBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.UNDERGROUND_STRUCTURES, ICE_DRAGON_CAVE_CF);
                LOADED_FEATURES.put("ICE_DRAGON_CAVE_CF", true);
            }
        }
        if (IafConfig.generateCyclopsCaves && IafWorldRegistry.safelyTestBiome(BiomeConfig.cyclopsCaveBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, CYCLOPS_CAVE_CF);
            LOADED_FEATURES.put("CYCLOPS_CAVE_CF", true);
        }
        if (IafConfig.spawnPixies && IafWorldRegistry.safelyTestBiome(BiomeConfig.pixieBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, PIXIE_VILLAGE_CF);
            LOADED_FEATURES.put("PIXIE_VILLAGE_CF", true);
        }
        if (IafConfig.generateHydraCaves && IafWorldRegistry.safelyTestBiome(BiomeConfig.hydraBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, HYDRA_CAVE_CF);
            LOADED_FEATURES.put("HYDRA_CAVE_CF", true);
        }
        if (IafConfig.generateMyrmexColonies && IafWorldRegistry.safelyTestBiome(BiomeConfig.desertMyrmexBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, MYRMEX_HIVE_DESERT_CF);
            LOADED_FEATURES.put("MYRMEX_HIVE_DESERT_CF", true);
        }
        if (IafConfig.generateMyrmexColonies && IafWorldRegistry.safelyTestBiome(BiomeConfig.jungleMyrmexBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, MYRMEX_HIVE_JUNGLE_CF);
            LOADED_FEATURES.put("MYRMEX_HIVE_JUNGLE_CF", true);
        }
        if (IafConfig.generateSirenIslands && IafWorldRegistry.safelyTestBiome(BiomeConfig.sirenBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SIREN_ISLAND_CF);
            LOADED_FEATURES.put("SIREN_ISLAND_CF", true);
        }
        if (IafConfig.spawnDeathWorm && IafWorldRegistry.safelyTestBiome(BiomeConfig.deathwormBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_DEATH_WORM_CF);
            LOADED_FEATURES.put("SPAWN_DEATH_WORM_CF", true);
        }
        if (IafConfig.generateWanderingCyclops && IafWorldRegistry.safelyTestBiome(BiomeConfig.wanderingCyclopsBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_WANDERING_CYCLOPS_CF);
            LOADED_FEATURES.put("SPAWN_WANDERING_CYCLOPS_CF", true);
        }
        if (IafConfig.generateDragonSkeletons) {
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.lightningDragonSkeletonBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_DRAGON_SKELETON_L_CF);
                LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_L_CF", true);
            }
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.fireDragonSkeletonBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_DRAGON_SKELETON_F_CF);
                LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_F_CF", true);
            }
            if (IafWorldRegistry.safelyTestBiome(BiomeConfig.iceDragonSkeletonBiomes, biomeHolder)) {
                generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_DRAGON_SKELETON_I_CF);
                LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_I_CF", true);
            }
        }
        if (IafConfig.spawnHippocampus && IafWorldRegistry.safelyTestBiome(BiomeConfig.hippocampusBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_HIPPOCAMPUS_CF);
            LOADED_FEATURES.put("SPAWN_HIPPOCAMPUS_CF", true);
        }
        if (IafConfig.spawnSeaSerpents && IafWorldRegistry.safelyTestBiome(BiomeConfig.seaSerpentBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_SEA_SERPENT_CF);
            LOADED_FEATURES.put("SPAWN_SEA_SERPENT_CF", true);
        }
        if (IafConfig.spawnStymphalianBirds && IafWorldRegistry.safelyTestBiome(BiomeConfig.stymphalianBiomes, biomeHolder)) {
            generator.m_204201_(GenerationStep.Decoration.SURFACE_STRUCTURES, SPAWN_STYMPHALIAN_BIRD_CF);
            LOADED_FEATURES.put("SPAWN_STYMPHALIAN_BIRD_CF", true);
        }
        ((Biome)biomeHolder.m_203334_()).f_47438_ = generator.m_47831_();
        processed.add(((Biome)biomeHolder.m_203334_()).f_47438_);
    }

    private static boolean safelyTestBiome(Pair<String, IafSpawnBiomeData> entry, Holder<Biome> biomeHolder) {
        try {
            return BiomeConfig.test(entry, biomeHolder);
        }
        catch (Exception e) {
            return false;
        }
    }

    static {
        GORGON_TEMPLE = STRUCTURES.register("gorgon_temple", GorgonTempleStructure::new);
        MAUSOLEUM = STRUCTURES.register("mausoleum", DreadMausoleumStructure::new);
        GRAVEYARD = STRUCTURES.register("graveyard", GraveyardStructure::new);
        HAS_GORGON_TEMPLE = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("iceandfire", "has_structure/gorgon_temple"));
        HAS_MAUSOLEUM = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("iceandfire", "has_structure/mausoleum"));
        HAS_GRAVEYARD = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("iceandfire", "has_structure/graveyard"));
        RL_IAF_STRUCTURE_SET = new ResourceLocation("iceandfire", "iaf_structure_set");
        IAF_STRUCTURE_SET = TagKey.m_203882_((ResourceKey)Registry.f_211073_, (ResourceLocation)RL_IAF_STRUCTURE_SET);
        FIRE_DRAGON_ROOST = IafWorldRegistry.register("fire_dragon_roost", () -> new WorldGenFireDragonRoosts((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        ICE_DRAGON_ROOST = IafWorldRegistry.register("ice_dragon_roost", () -> new WorldGenIceDragonRoosts((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        LIGHTNING_DRAGON_ROOST = IafWorldRegistry.register("lightning_dragon_roost", () -> new WorldGenLightningDragonRoosts((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        FIRE_DRAGON_CAVE = IafWorldRegistry.register("fire_dragon_cave", () -> new WorldGenFireDragonCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        ICE_DRAGON_CAVE = IafWorldRegistry.register("ice_dragon_cave", () -> new WorldGenIceDragonCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        LIGHTNING_DRAGON_CAVE = IafWorldRegistry.register("lightning_dragon_cave", () -> new WorldGenLightningDragonCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        CYCLOPS_CAVE = IafWorldRegistry.register("cyclops_cave", () -> new WorldGenCyclopsCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        PIXIE_VILLAGE = IafWorldRegistry.register("pixie_village", () -> new WorldGenPixieVillage((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SIREN_ISLAND = IafWorldRegistry.register("siren_island", () -> new WorldGenSirenIsland((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        HYDRA_CAVE = IafWorldRegistry.register("hydra_cave", () -> new WorldGenHydraCave((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        MYRMEX_HIVE_DESERT = IafWorldRegistry.register("myrmex_hive_desert", () -> new WorldGenMyrmexHive(false, false, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        MYRMEX_HIVE_JUNGLE = IafWorldRegistry.register("myrmex_hive_jungle", () -> new WorldGenMyrmexHive(false, true, (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_DEATH_WORM = IafWorldRegistry.register("spawn_death_worm", () -> new SpawnDeathWorm((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_DRAGON_SKELETON_L = IafWorldRegistry.register("spawn_dragon_skeleton_l", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntityRegistry.LIGHTNING_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_DRAGON_SKELETON_F = IafWorldRegistry.register("spawn_dragon_skeleton_f", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntityRegistry.FIRE_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_DRAGON_SKELETON_I = IafWorldRegistry.register("spawn_dragon_skeleton_i", () -> new SpawnDragonSkeleton((EntityType<? extends EntityDragonBase>)((EntityType)IafEntityRegistry.ICE_DRAGON.get()), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_HIPPOCAMPUS = IafWorldRegistry.register("spawn_hippocampus", () -> new SpawnHippocampus((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_SEA_SERPENT = IafWorldRegistry.register("spawn_sea_serpent", () -> new SpawnSeaSerpent((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_STYMPHALIAN_BIRD = IafWorldRegistry.register("spawn_stymphalian_bird", () -> new SpawnStymphalianBird((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        SPAWN_WANDERING_CYCLOPS = IafWorldRegistry.register("spawn_wandering_cyclops", () -> new SpawnWanderingCyclops((Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_));
        registerSimple = (name, feat) -> IafWorldRegistry.register("%s:%s".formatted("iceandfire", name), new ConfiguredFeature(feat, (FeatureConfiguration)FeatureConfiguration.f_67737_), new PlacementModifier[]{BiomeFilter.m_191561_()});
        LOADED_FEATURES = new HashMap();
        LOADED_FEATURES.put("FIRE_LILY_CF", false);
        LOADED_FEATURES.put("FROST_LILY_CF", false);
        LOADED_FEATURES.put("LIGHTNING_LILY_CF", false);
        LOADED_FEATURES.put("COPPER_ORE_CF", false);
        LOADED_FEATURES.put("SILVER_ORE_CF", false);
        LOADED_FEATURES.put("SAPPHIRE_ORE_CF", false);
        LOADED_FEATURES.put("AMETHYST_ORE_CF", false);
        LOADED_FEATURES.put("FIRE_DRAGON_ROOST_CF", false);
        LOADED_FEATURES.put("ICE_DRAGON_ROOST_CF", false);
        LOADED_FEATURES.put("LIGHTNING_DRAGON_ROOST_CF", false);
        LOADED_FEATURES.put("FIRE_DRAGON_CAVE_CF", false);
        LOADED_FEATURES.put("ICE_DRAGON_CAVE_CF", false);
        LOADED_FEATURES.put("LIGHTNING_DRAGON_CAVE_CF", false);
        LOADED_FEATURES.put("CYCLOPS_CAVE_CF", false);
        LOADED_FEATURES.put("PIXIE_VILLAGE_CF", false);
        LOADED_FEATURES.put("SIREN_ISLAND_CF", false);
        LOADED_FEATURES.put("HYDRA_CAVE_CF", false);
        LOADED_FEATURES.put("MYRMEX_HIVE_DESERT_CF", false);
        LOADED_FEATURES.put("MYRMEX_HIVE_JUNGLE_CF", false);
        LOADED_FEATURES.put("SPAWN_DEATH_WORM_CF", false);
        LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_L_CF", false);
        LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_F_CF", false);
        LOADED_FEATURES.put("SPAWN_DRAGON_SKELETON_I_CF", false);
        LOADED_FEATURES.put("SPAWN_HIPPOCAMPUS_CF", false);
        LOADED_FEATURES.put("SPAWN_SEA_SERPENT_CF", false);
        LOADED_FEATURES.put("SPAWN_STYMPHALIAN_BIRD_CF", false);
        LOADED_FEATURES.put("SPAWN_WANDERING_CYCLOPS_CF", false);
        processed = new HashSet<BiomeGenerationSettings>();
    }
}

