/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.pathfinding.raycoms;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.MNode;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.AbstractPathJob;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraftforge.common.util.LogicalSidedProvider;
import net.minecraftforge.fml.LogicalSide;
import org.jetbrains.annotations.NotNull;

public final class Pathfinding {
    private static final BlockingQueue<Runnable> jobQueue = new LinkedBlockingDeque<Runnable>();
    private static ThreadPoolExecutor executor;
    public static Set<MNode> lastDebugNodesVisited;
    public static Set<MNode> lastDebugNodesNotVisited;
    public static Set<MNode> lastDebugNodesPath;

    private Pathfinding() {
    }

    public static boolean isDebug() {
        return IafConfig.pathfindingDebug;
    }

    public static ThreadPoolExecutor getExecutor() {
        if (executor == null) {
            executor = new ThreadPoolExecutor(1, IafConfig.dragonPathfindingThreads, 10L, TimeUnit.SECONDS, jobQueue, new IafThreadFactory());
        }
        return executor;
    }

    public static void shutdown() {
        Pathfinding.getExecutor().shutdownNow();
        jobQueue.clear();
        executor = null;
    }

    public static void enqueue(AbstractPathJob job) {
        job.getResult().startJob(Pathfinding.getExecutor());
    }

    static {
        lastDebugNodesVisited = new HashSet<MNode>();
        lastDebugNodesNotVisited = new HashSet<MNode>();
        lastDebugNodesPath = new HashSet<MNode>();
    }

    public static class IafThreadFactory
    implements ThreadFactory {
        public static int id;

        @Override
        public Thread newThread(@NotNull Runnable runnable) {
            BlockableEventLoop workqueue = (BlockableEventLoop)LogicalSidedProvider.WORKQUEUE.get(LogicalSide.SERVER);
            ClassLoader classLoader = workqueue.m_18695_() ? Thread.currentThread().getContextClassLoader() : CompletableFuture.supplyAsync(() -> Thread.currentThread().getContextClassLoader(), (Executor)workqueue).join();
            Thread thread = new Thread(runnable, "Ice and Fire Pathfinding Worker #" + id++);
            thread.setDaemon(true);
            thread.setPriority(10);
            if (thread.getContextClassLoader() != classLoader) {
                IceAndFire.LOGGER.info("Corrected CCL of new Ice and Fire Pathfinding Thread, was: " + thread.getContextClassLoader().toString());
                thread.setContextClassLoader(classLoader);
            }
            thread.setUncaughtExceptionHandler((thread1, throwable) -> IceAndFire.LOGGER.error("Ice and Fire Pathfinding Thread errored! ", throwable));
            return thread;
        }
    }
}

