/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.item;

import com.github.alexthe666.citadel.server.item.CustomArmorMaterial;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.model.armor.ModelTrollArmor;
import com.github.alexthe666.iceandfire.enums.EnumTroll;
import java.util.List;
import java.util.Locale;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.IItemRenderProperties;
import org.jetbrains.annotations.NotNull;

public class ItemTrollArmor
extends ArmorItem {
    public EnumTroll troll;

    public ItemTrollArmor(EnumTroll troll, CustomArmorMaterial material, EquipmentSlot slot) {
        super((ArmorMaterial)material, slot, new Item.Properties().m_41491_(IceAndFire.TAB_ITEMS));
        this.troll = troll;
    }

    public static String getName(EnumTroll troll, EquipmentSlot slot) {
        return "%s_troll_leather_%s".formatted(troll.name().toLowerCase(Locale.ROOT), ItemTrollArmor.getArmorPart(slot));
    }

    @NotNull
    public ArmorMaterial m_40401_() {
        return this.troll.material;
    }

    private static String getArmorPart(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> "helmet";
            case EquipmentSlot.CHEST -> "chestplate";
            case EquipmentSlot.LEGS -> "leggings";
            case EquipmentSlot.FEET -> "boots";
            default -> "";
        };
    }

    public void initializeClient(Consumer<IItemRenderProperties> consumer) {
        consumer.accept(new IItemRenderProperties(){

            @Nullable
            public HumanoidModel<?> getArmorModel(LivingEntity LivingEntity2, ItemStack itemStack, EquipmentSlot armorSlot, HumanoidModel<?> _default) {
                return new ModelTrollArmor(armorSlot == EquipmentSlot.LEGS || armorSlot == EquipmentSlot.HEAD);
            }
        });
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "iceandfire:textures/models/armor/armor_troll_" + this.troll.name().toLowerCase(Locale.ROOT) + (slot == EquipmentSlot.LEGS ? "_legs.png" : ".png");
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)new TranslatableComponent("item.iceandfire.troll_leather_armor_" + ItemTrollArmor.getArmorPart(this.f_40377_) + ".desc").m_130940_(ChatFormatting.GREEN));
    }
}

