/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;

public interface IHasCustomizableAttributes {
    public static final Map<EntityType<? extends LivingEntity>, AttributeSupplier> ATTRIBUTE_MODIFIER_MAP = new HashMap<EntityType<? extends LivingEntity>, AttributeSupplier>();

    public static <T extends LivingEntity, M extends LivingEntity> void applyAttributesForEntity(EntityType<T> type, M entity) {
        entity.f_20943_ = new AttributeMap(IHasCustomizableAttributes.getAttributesForEntity(type, entity));
        entity.m_21153_(entity.m_21233_());
    }

    public static <T extends LivingEntity, M extends LivingEntity> AttributeSupplier getAttributesForEntity(EntityType<T> type, M entity) {
        if (!IafConfig.allowAttributeOverriding) {
            return DefaultAttributes.m_22297_(type);
        }
        if (ATTRIBUTE_MODIFIER_MAP.containsKey(type)) {
            return ATTRIBUTE_MODIFIER_MAP.get(type);
        }
        AttributeSupplier originalMap = DefaultAttributes.m_22297_(type);
        AttributeSupplier.Builder originalMutable = new AttributeSupplier.Builder(originalMap);
        originalMutable.combine(((IHasCustomizableAttributes)entity).getConfigurableAttributes());
        AttributeSupplier newMap = originalMutable.m_22265_();
        ATTRIBUTE_MODIFIER_MAP.put(type, newMap);
        return newMap;
    }

    public AttributeSupplier.Builder getConfigurableAttributes();
}

