/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexBase;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexEgg;
import com.github.alexthe666.iceandfire.entity.EntityMyrmexWorker;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIAttackPlayers;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIDefendHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAILookAtTradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIReEnterHive;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAITradePlayer;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexAIWanderHiveCenter;
import com.github.alexthe666.iceandfire.entity.ai.MyrmexQueenAIWander;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.MyrmexHive;
import com.github.alexthe666.iceandfire.entity.util.MyrmexTrades;
import com.github.alexthe666.iceandfire.world.gen.WorldGenMyrmexHive;
import com.mojang.serialization.Codec;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class EntityMyrmexQueen
extends EntityMyrmexBase {
    public static final Animation ANIMATION_BITE = Animation.create((int)15);
    public static final Animation ANIMATION_STING = Animation.create((int)15);
    public static final Animation ANIMATION_EGG = Animation.create((int)20);
    public static final Animation ANIMATION_DIGNEST = Animation.create((int)45);
    public static final ResourceLocation DESERT_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_queen_desert");
    public static final ResourceLocation JUNGLE_LOOT = new ResourceLocation("iceandfire", "entities/myrmex_queen_jungle");
    private static final ResourceLocation TEXTURE_DESERT = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_desert_queen.png");
    private static final ResourceLocation TEXTURE_JUNGLE = new ResourceLocation("iceandfire:textures/models/myrmex/myrmex_jungle_queen.png");
    private static final EntityDataAccessor<Boolean> HASMADEHOME = SynchedEntityData.m_135353_(EntityMyrmexQueen.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int eggTicks = 0;

    public EntityMyrmexQueen(EntityType<EntityMyrmexQueen> t, Level worldIn) {
        super(t, worldIn);
    }

    @Nullable
    protected ResourceLocation m_7582_() {
        return this.isJungle() ? JUNGLE_LOOT : DESERT_LOOT;
    }

    @Override
    protected int m_6552_(Player player) {
        return 20;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HASMADEHOME, (Object)Boolean.TRUE);
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel1Trades() {
        return this.isJungle() ? (VillagerTrades.ItemListing[])MyrmexTrades.JUNGLE_QUEEN.get(1) : (VillagerTrades.ItemListing[])MyrmexTrades.DESERT_QUEEN.get(1);
    }

    @Override
    protected VillagerTrades.ItemListing[] getLevel2Trades() {
        return this.isJungle() ? (VillagerTrades.ItemListing[])MyrmexTrades.JUNGLE_QUEEN.get(2) : (VillagerTrades.ItemListing[])MyrmexTrades.DESERT_QUEEN.get(2);
    }

    public void m_6593_(Component name) {
        if (this.getHive() != null && !this.getHive().colonyName.equals(name.m_6111_())) {
            this.getHive().colonyName = name.getString();
        }
        super.m_6593_(name);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("EggTicks", this.eggTicks);
        tag.m_128379_("MadeHome", this.hasMadeHome());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.eggTicks = tag.m_128451_("EggTicks");
        this.setMadeHome(tag.m_128471_("MadeHome"));
    }

    public boolean hasMadeHome() {
        return (Boolean)this.f_19804_.m_135370_(HASMADEHOME);
    }

    public void setMadeHome(boolean madeHome) {
        this.f_19804_.m_135381_(HASMADEHOME, (Object)madeHome);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.getAnimation() == ANIMATION_DIGNEST) {
            this.spawnGroundEffects(3.0f);
        }
        if (this.getHive() != null) {
            this.getHive().tick(0, this.f_19853_);
        }
        if (this.hasMadeHome() && this.getGrowthStage() >= 2 && !this.canSeeSky()) {
            ++this.eggTicks;
        } else if (this.canSeeSky()) {
            this.setAnimation(ANIMATION_DIGNEST);
            if (this.getAnimationTick() == 42) {
                int down = Math.max(15, this.m_142538_().m_123342_() - 20 + this.m_21187_().nextInt(10));
                BlockPos genPos = new BlockPos(this.m_20185_(), (double)down, this.m_20189_());
                if (!MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, genPos.m_123341_(), genPos.m_123342_(), genPos.m_123343_()))) {
                    WorldGenMyrmexHive hiveGen = new WorldGenMyrmexHive(true, this.isJungle(), (Codec<NoneFeatureConfiguration>)NoneFeatureConfiguration.f_67815_);
                    if (!this.f_19853_.f_46443_ && this.f_19853_ instanceof ServerLevel) {
                        hiveGen.placeSmallGen((WorldGenLevel)((ServerLevel)this.f_19853_), this.m_21187_(), genPos);
                    }
                    this.setMadeHome(true);
                    this.m_7678_(genPos.m_123341_(), down, genPos.m_123343_(), 0.0f, 0.0f);
                    this.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 30));
                    this.setHive(hiveGen.hive);
                    for (int i = 0; i < 3; ++i) {
                        EntityMyrmexWorker worker = new EntityMyrmexWorker((EntityType<EntityMyrmexWorker>)((EntityType)IafEntityRegistry.MYRMEX_WORKER.get()), this.f_19853_);
                        worker.m_20359_((Entity)this);
                        worker.setHive(this.getHive());
                        worker.setJungleVariant(this.isJungle());
                        if (this.f_19853_.f_46443_) continue;
                        this.f_19853_.m_7967_((Entity)worker);
                    }
                    return;
                }
            }
        }
        if (!this.f_19853_.f_46443_ && this.eggTicks > IafConfig.myrmexPregnantTicks && this.getHive() == null || !this.f_19853_.f_46443_ && this.getHive() != null && this.getHive().repopulate() && this.eggTicks > IafConfig.myrmexPregnantTicks) {
            float radius = -5.25f;
            float angle = (float)Math.PI / 180 * this.f_20883_;
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            BlockPos eggPos = new BlockPos(this.m_20185_() + extraX, this.m_20186_() + 0.75, this.m_20189_() + extraZ);
            if (this.f_19853_.m_46859_(eggPos)) {
                this.setAnimation(ANIMATION_EGG);
                if (this.getAnimationTick() == 10) {
                    EntityMyrmexEgg egg = new EntityMyrmexEgg((EntityType)IafEntityRegistry.MYRMEX_EGG.get(), this.f_19853_);
                    egg.setJungle(this.isJungle());
                    int caste = EntityMyrmexQueen.getRandomCaste(this.f_19853_, this.m_21187_(), this.getHive() == null || this.getHive().reproduces);
                    egg.setMyrmexCaste(caste);
                    egg.m_7678_(this.m_20185_() + extraX, this.m_20186_() + 0.75, this.m_20189_() + extraZ, 0.0f, 0.0f);
                    if (this.getHive() != null) {
                        egg.hiveUUID = this.getHive().hiveUUID;
                    }
                    if (!this.f_19853_.f_46443_) {
                        this.f_19853_.m_7967_((Entity)egg);
                    }
                    this.eggTicks = 0;
                }
            }
        }
        if (this.getAnimation() == ANIMATION_BITE && this.m_5448_() != null && this.getAnimationTick() == 6) {
            this.playBiteSound();
            if (this.getAttackBounds().m_82381_(this.m_5448_().m_142469_())) {
                this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
            }
        }
        if (this.getAnimation() == ANIMATION_STING && this.getAnimationTick() == 0) {
            this.playStingSound();
        }
        if (this.getAnimation() == ANIMATION_STING && this.m_5448_() != null && this.getAnimationTick() == 6 && this.getAttackBounds().m_82381_(this.m_5448_().m_142469_())) {
            LivingEntity attackTarget = this.m_5448_();
            this.m_5448_().m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_() * 2));
            this.m_5448_().m_7292_(new MobEffectInstance(MobEffects.f_19614_, 200, 2));
            this.m_5448_().f_19812_ = true;
            float f = Mth.m_14116_((float)0.5f);
            this.m_5448_().f_19812_ = true;
            attackTarget.m_20256_(attackTarget.m_20184_().m_82542_(0.5, 1.0, 0.5));
            attackTarget.m_20256_(attackTarget.m_20184_().m_82520_(-0.5 / (double)f * 4.0, 1.0, -0.5 / (double)f * 4.0));
            if (this.m_5448_().m_20096_()) {
                attackTarget.m_20256_(attackTarget.m_20184_().m_82520_(0.0, 0.4, 0.0));
            }
        }
    }

    public boolean m_6673_(@NotNull DamageSource source) {
        return super.m_6673_(source) || this.getAnimation() == ANIMATION_DIGNEST;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAITradePlayer(this));
        this.f_21345_.m_25352_(0, (Goal)new MyrmexAILookAtTradePlayer(this));
        this.f_21345_.m_25352_(1, (Goal)new MyrmexAIAttackMelee(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new MyrmexAIReEnterHive(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MyrmexAIWanderHiveCenter(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new MyrmexQueenAIWander(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new MyrmexAIDefendHive(this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(3, (Goal)new MyrmexAIAttackPlayers(this));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 10, true, true, (Predicate)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return entity != null && !EntityMyrmexBase.haveSameHive(EntityMyrmexQueen.this, (Entity)entity) && DragonUtils.isAlive(entity) && !(entity instanceof Enemy);
            }
        }));
    }

    public void fall(float distance, float damageMultiplier) {
    }

    @Override
    public boolean isInHive() {
        if (this.getHive() != null) {
            for (BlockPos pos : this.getHive().getAllRooms()) {
                if (!this.isCloseEnoughToTarget(MyrmexHive.getGroundedPos((LevelAccessor)this.m_183503_(), pos), 300.0)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean shouldMoveThroughHive() {
        return false;
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, IafConfig.myrmexBaseAttackStrength * 3.5).m_22268_(Attributes.f_22277_, 128.0).m_22268_(Attributes.f_22284_, 15.0);
    }

    @Override
    public AttributeSupplier.Builder getConfigurableAttributes() {
        return EntityMyrmexQueen.bakeAttributes();
    }

    @Override
    public ResourceLocation getAdultTexture() {
        return this.isJungle() ? TEXTURE_JUNGLE : TEXTURE_DESERT;
    }

    @Override
    public float getModelScale() {
        return 1.75f;
    }

    @Override
    public int getCasteImportance() {
        return 3;
    }

    @Override
    public boolean shouldLeaveHive() {
        return false;
    }

    @Override
    public boolean shouldEnterHive() {
        return true;
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        if (this.getGrowthStage() < 2) {
            return false;
        }
        if (this.getAnimation() != ANIMATION_STING && this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(this.m_21187_().nextBoolean() ? ANIMATION_STING : ANIMATION_BITE);
            if (!this.f_19853_.f_46443_ && this.m_21187_().nextInt(3) == 0 && this.m_21120_(InteractionHand.MAIN_HAND) != ItemStack.f_41583_) {
                this.m_5552_(this.m_21120_(InteractionHand.MAIN_HAND), 0.0f);
                this.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
            }
            if (!this.m_20197_().isEmpty()) {
                for (Entity entity : this.m_20197_()) {
                    entity.m_8127_();
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canMove() {
        return super.canMove() && this.hasMadeHome();
    }

    public void spawnGroundEffects(float size) {
        int i = 0;
        while ((float)i < size * 3.0f) {
            for (int i1 = 0; i1 < 10; ++i1) {
                double motionX = this.m_21187_().nextGaussian() * 0.07;
                double motionY = this.m_21187_().nextGaussian() * 0.07;
                double motionZ = this.m_21187_().nextGaussian() * 0.07;
                float radius = size * this.f_19796_.nextFloat();
                float angle = (float)Math.PI / 180 * this.f_20883_ * 3.14f * this.f_19796_.nextFloat();
                double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                double extraY = 0.8f;
                double extraZ = radius * Mth.m_14089_((float)angle);
                BlockState BlockState2 = this.f_19853_.m_8055_(new BlockPos(Mth.m_14107_((double)(this.m_20185_() + extraX)), Mth.m_14107_((double)(this.m_20186_() + extraY)) - 1, Mth.m_14107_((double)(this.m_20189_() + extraZ))));
                if (BlockState2.m_60767_() == Material.f_76296_ || !this.f_19853_.f_46443_) continue;
                this.f_19853_.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, BlockState2), true, this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ, motionX, motionY, motionZ);
            }
            ++i;
        }
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_PUPA_WIGGLE, ANIMATION_BITE, ANIMATION_STING, ANIMATION_EGG, ANIMATION_DIGNEST};
    }

    public int m_7809_() {
        return 0;
    }

    public boolean m_7826_() {
        return false;
    }

    public boolean m_183595_() {
        return false;
    }
}

