/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.iceandfire.entity.util.IBlacklistedFromStatues;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.google.common.collect.ImmutableList;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EntityDragonEgg
extends LivingEntity
implements IBlacklistedFromStatues,
IDeadMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UNIQUE_ID = SynchedEntityData.m_135353_(EntityDragonEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);
    private static final EntityDataAccessor<Integer> DRAGON_TYPE = SynchedEntityData.m_135353_(EntityDragonEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DRAGON_AGE = SynchedEntityData.m_135353_(EntityDragonEgg.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public EntityDragonEgg(EntityType type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.0);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("Color", (int)((byte)this.getEggType().ordinal()));
        tag.m_128405_("DragonAge", this.getDragonAge());
        try {
            if (this.getOwnerId() == null) {
                tag.m_128359_("OwnerUUID", "");
            } else {
                tag.m_128359_("OwnerUUID", this.getOwnerId().toString());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        String s;
        super.m_7378_(tag);
        this.setEggType(EnumDragonEgg.values()[tag.m_128451_("Color")]);
        this.setDragonAge(tag.m_128451_("DragonAge"));
        if (tag.m_128425_("OwnerUUID", 8)) {
            s = tag.m_128461_("OwnerUUID");
        } else {
            String s1 = tag.m_128461_("Owner");
            UUID converedUUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)s1);
            String string = s = converedUUID == null ? s1 : converedUUID.toString();
        }
        if (!s.isEmpty()) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DRAGON_TYPE, (Object)0);
        this.m_20088_().m_135372_(DRAGON_AGE, (Object)0);
        this.m_20088_().m_135372_(OWNER_UNIQUE_ID, Optional.empty());
    }

    @Nullable
    public UUID getOwnerId() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UNIQUE_ID)).orElse(null);
    }

    public void setOwnerId(@Nullable UUID p_184754_1_) {
        this.f_19804_.m_135381_(OWNER_UNIQUE_ID, Optional.ofNullable(p_184754_1_));
    }

    public EnumDragonEgg getEggType() {
        return EnumDragonEgg.values()[(Integer)this.m_20088_().m_135370_(DRAGON_TYPE)];
    }

    public void setEggType(EnumDragonEgg newtype) {
        this.m_20088_().m_135381_(DRAGON_TYPE, (Object)newtype.ordinal());
    }

    public boolean m_6673_(DamageSource i) {
        return i.m_7639_() != null && super.m_6673_(i);
    }

    public int getDragonAge() {
        return (Integer)this.m_20088_().m_135370_(DRAGON_AGE);
    }

    public void setDragonAge(int i) {
        this.m_20088_().m_135381_(DRAGON_AGE, (Object)i);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            this.m_20301_(200);
            this.getEggType().dragonType.updateEggCondition(this);
        }
    }

    public SoundEvent m_7975_(@NotNull DamageSource damageSourceIn) {
        return null;
    }

    @NotNull
    public Iterable<ItemStack> m_6168_() {
        return ImmutableList.of();
    }

    @NotNull
    public ItemStack m_6844_(@NotNull EquipmentSlot slotIn) {
        return ItemStack.f_41583_;
    }

    public void m_8061_(@NotNull EquipmentSlot slotIn, @NotNull ItemStack stack) {
    }

    public boolean m_6469_(@NotNull DamageSource var1, float var2) {
        if (!(this.f_19853_.f_46443_ || var1.m_19378_() || this.m_146910_())) {
            this.m_20000_((ItemLike)this.getItem().m_41720_(), 1);
        }
        this.m_142687_(Entity.RemovalReason.KILLED);
        return true;
    }

    private ItemStack getItem() {
        return switch (this.getEggType().ordinal()) {
            default -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_RED.get());
            case 1 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_GREEN.get());
            case 2 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_BRONZE.get());
            case 3 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_GRAY.get());
            case 4 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_BLUE.get());
            case 5 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_WHITE.get());
            case 6 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_SAPPHIRE.get());
            case 7 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_SILVER.get());
            case 8 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_ELECTRIC.get());
            case 9 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_AMYTHEST.get());
            case 10 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_COPPER.get());
            case 11 -> new ItemStack((ItemLike)IafItemRegistry.DRAGONEGG_BLACK.get());
        };
    }

    public boolean m_6094_() {
        return false;
    }

    @NotNull
    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    protected void m_7324_(@NotNull Entity entity) {
    }

    @Override
    public boolean canBeTurnedToStone() {
        return false;
    }

    public void onPlayerPlace(Player player) {
        this.setOwnerId(player.m_142081_());
    }

    @Override
    public boolean isMobDead() {
        return true;
    }
}

