/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity;

import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.api.FoodUtils;
import com.github.alexthe666.iceandfire.api.event.GenericGriefEvent;
import com.github.alexthe666.iceandfire.block.IDragonProof;
import com.github.alexthe666.iceandfire.client.model.IFChainBuffer;
import com.github.alexthe666.iceandfire.client.model.util.LegSolverQuadruped;
import com.github.alexthe666.iceandfire.entity.DragonType;
import com.github.alexthe666.iceandfire.entity.EntityDragonEgg;
import com.github.alexthe666.iceandfire.entity.EntityDragonPart;
import com.github.alexthe666.iceandfire.entity.EntityDreadQueen;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.IafDragonAttacks;
import com.github.alexthe666.iceandfire.entity.IafDragonFlightManager;
import com.github.alexthe666.iceandfire.entity.IafDragonLogic;
import com.github.alexthe666.iceandfire.entity.IafEntityRegistry;
import com.github.alexthe666.iceandfire.entity.ai.AquaticAITempt;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIAttackMelee;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIEscort;
import com.github.alexthe666.iceandfire.entity.ai.DragonAILookIdle;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIMate;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIReturnToRoost;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITarget;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetItems;
import com.github.alexthe666.iceandfire.entity.ai.DragonAITargetNonTamed;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWander;
import com.github.alexthe666.iceandfire.entity.ai.DragonAIWatchClosest;
import com.github.alexthe666.iceandfire.entity.props.ChainProperties;
import com.github.alexthe666.iceandfire.entity.props.MiscProperties;
import com.github.alexthe666.iceandfire.entity.tile.TileEntityDragonforgeInput;
import com.github.alexthe666.iceandfire.entity.util.ChainBuffer;
import com.github.alexthe666.iceandfire.entity.util.DragonUtils;
import com.github.alexthe666.iceandfire.entity.util.HomePosition;
import com.github.alexthe666.iceandfire.entity.util.IAnimalFear;
import com.github.alexthe666.iceandfire.entity.util.ICustomMoveController;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.entity.util.IDragonFlute;
import com.github.alexthe666.iceandfire.entity.util.IDropArmor;
import com.github.alexthe666.iceandfire.entity.util.IFlyingMount;
import com.github.alexthe666.iceandfire.entity.util.IHasCustomizableAttributes;
import com.github.alexthe666.iceandfire.entity.util.IMultipartEntity;
import com.github.alexthe666.iceandfire.entity.util.ISyncMount;
import com.github.alexthe666.iceandfire.entity.util.IVillagerFear;
import com.github.alexthe666.iceandfire.entity.util.ReversedBuffer;
import com.github.alexthe666.iceandfire.enums.EnumDragonEgg;
import com.github.alexthe666.iceandfire.inventory.ContainerDragon;
import com.github.alexthe666.iceandfire.item.IafItemRegistry;
import com.github.alexthe666.iceandfire.item.ItemDragonArmor;
import com.github.alexthe666.iceandfire.item.ItemSummoningCrystal;
import com.github.alexthe666.iceandfire.message.MessageDragonSetBurnBlock;
import com.github.alexthe666.iceandfire.message.MessageStartRidingMob;
import com.github.alexthe666.iceandfire.misc.IafSoundRegistry;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.AdvancedPathNavigate;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.IPassabilityNavigator;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.PathingStuckHandler;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.github.alexthe666.iceandfire.world.DragonPosWorldData;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerListener;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class EntityDragonBase
extends TamableAnimal
implements IPassabilityNavigator,
ISyncMount,
IFlyingMount,
IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IDropArmor,
IHasCustomizableAttributes,
ICustomSizeNavigator,
ICustomMoveController,
ContainerListener {
    public static final int FLIGHT_CHANCE_PER_TICK = 1500;
    protected static final EntityDataAccessor<Boolean> SWIMMING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final EntityDataAccessor<Integer> HUNGER = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AGE_TICKS = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> GENDER = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> VARIANT = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> SLEEPING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FIREBREATHING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HOVERING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> FLYING = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> MODEL_DEAD = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DEATH_STAGE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Byte> CONTROL_STATE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> TACKLE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> AGINGDISABLED = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> COMMAND = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Float> DRAGON_PITCH = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> CRYSTAL_BOUND = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<String> CUSTOM_POSE = SynchedEntityData.m_135353_(EntityDragonBase.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    public static Animation ANIMATION_FIRECHARGE;
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EPIC_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public DragonType dragonType;
    public double minimumDamage;
    public double maximumDamage;
    public double minimumHealth;
    public double maximumHealth;
    public double minimumSpeed;
    public double maximumSpeed;
    public double minimumArmor;
    public double maximumArmor;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevDiveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float prevModelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public boolean isSwimming;
    public float prevSwimProgress;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;
    public float[] prevAnimationProgresses = new float[10];
    public boolean isDaytime;
    public int flightCycle;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer pitch_buffer;
    public IFChainBuffer pitch_buffer_body;
    public ReversedBuffer turn_buffer;
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public float[][] growth_stages;
    public LegSolverQuadruped legSolver;
    public int walkCycle;
    public BlockPos burningTarget;
    public int burnProgress;
    public double burnParticleX;
    public double burnParticleY;
    public double burnParticleZ;
    public float prevDragonPitch;
    public IafDragonAttacks.Air airAttack;
    public IafDragonAttacks.Ground groundAttack;
    public boolean usingGroundAttack = true;
    public IafDragonLogic logic;
    public int hoverTicks;
    public int tacklingTicks;
    public int ticksStill;
    public int navigatorType;
    public SimpleContainer dragonInventory;
    public String prevArmorResLoc = "0|0|0|0";
    public String armorResLoc = "0|0|0|0";
    public IafDragonFlightManager flightManager;
    public boolean lookingForRoostAIFlag = false;
    protected int flyHovering;
    protected boolean hasHadHornUse = false;
    protected int fireTicks;
    protected int blockBreakCounter;
    private int prevFlightCycle;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    private float lastScale;
    private EntityDragonPart headPart;
    private EntityDragonPart neckPart;
    private EntityDragonPart rightWingUpperPart;
    private EntityDragonPart rightWingLowerPart;
    private EntityDragonPart leftWingUpperPart;
    private EntityDragonPart leftWingLowerPart;
    private EntityDragonPart tail1Part;
    private EntityDragonPart tail2Part;
    private EntityDragonPart tail3Part;
    private EntityDragonPart tail4Part;
    private boolean isOverAir;
    private LazyOptional<?> itemHandler = null;
    public boolean allowLocalMotionControl = true;
    public boolean allowMousePitchControl = true;
    protected boolean gliding = false;
    protected float glidingSpeedBonus = 0.0f;
    protected float riderWalkingExtraY = 0.0f;

    public EntityDragonBase(EntityType t, Level world, DragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(t, world);
        IHasCustomizableAttributes.applyAttributesForEntity(t, this);
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.createInventory();
        if (world.f_46443_) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.pitch_buffer_body = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.3f, 0.35f, 0.2f, 1.45f, 1.0f);
        this.flightManager = new IafDragonFlightManager(this);
        this.logic = this.createDragonLogic();
        this.f_19811_ = true;
        this.switchNavigator(0);
        this.randomizeAttacks();
        this.resetParts(1.0f);
    }

    public static AttributeSupplier.Builder bakeAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, (double)Math.min(2048, IafConfig.dragonTargetSearchLength)).m_22268_(Attributes.f_22284_, 4.0);
    }

    @Override
    public AttributeSupplier.Builder getConfigurableAttributes() {
        return EntityDragonBase.bakeAttributes();
    }

    @NotNull
    public BlockPos m_21534_() {
        return this.homePos == null ? super.m_21534_() : this.homePos.getPosition();
    }

    public float m_21535_() {
        return IafConfig.dragonWanderFromHomeDistance;
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean m_21536_() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.f_19853_)) || super.m_21536_();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(2, (Goal)new DragonAIMate(this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new DragonAIReturnToRoost(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new DragonAIEscort(this, 1.0));
        this.f_21345_.m_25352_(5, (Goal)new DragonAIAttackMelee(this, 1.5, false));
        this.f_21345_.m_25352_(6, (Goal)new AquaticAITempt((Mob)this, 1.0, (Supplier<Item>)IafItemRegistry.FIRE_STEW, false));
        this.f_21345_.m_25352_(7, (Goal)new DragonAIWander(this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new DragonAIWatchClosest((PathfinderMob)this, LivingEntity.class, 6.0f));
        this.f_21345_.m_25352_(8, (Goal)new DragonAILookIdle(this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, new DragonAITargetNonTamed<LivingEntity>(this, LivingEntity.class, false, (Predicate<LivingEntity>)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return (!(entity instanceof Player) || !((Player)entity).m_7500_()) && DragonUtils.canHostilesTarget((Entity)entity) && entity.m_6095_() != EntityDragonBase.this.m_6095_() && EntityDragonBase.this.shouldTarget((Entity)entity) && DragonUtils.isAlive(entity);
            }
        }));
        this.f_21346_.m_25352_(5, new DragonAITarget<LivingEntity>(this, LivingEntity.class, true, (Predicate<LivingEntity>)new com.google.common.base.Predicate<LivingEntity>(){

            public boolean apply(@Nullable LivingEntity entity) {
                return entity instanceof LivingEntity && DragonUtils.canHostilesTarget((Entity)entity) && entity.m_6095_() != EntityDragonBase.this.m_6095_() && EntityDragonBase.this.shouldTarget((Entity)entity) && DragonUtils.isAlive(entity);
            }
        }));
        this.f_21346_.m_25352_(6, new DragonAITargetItems(this, false));
    }

    protected abstract boolean shouldTarget(Entity var1);

    public void resetParts(float scale) {
        this.removeParts();
        this.headPart = new EntityDragonPart(this, 1.55f * scale, 0.0f, 0.6f * scale, 0.5f * scale, 0.35f * scale, 1.5f);
        this.headPart.m_20359_((Entity)this);
        this.headPart.setParent((Entity)this);
        this.neckPart = new EntityDragonPart(this, 0.85f * scale, 0.0f, 0.7f * scale, 0.5f * scale, 0.2f * scale, 1.0f);
        this.neckPart.m_20359_((Entity)this);
        this.neckPart.setParent((Entity)this);
        this.rightWingUpperPart = new EntityDragonPart(this, scale, 90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.rightWingUpperPart.m_20359_((Entity)this);
        this.rightWingUpperPart.setParent((Entity)this);
        this.rightWingLowerPart = new EntityDragonPart(this, 1.4f * scale, 100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.rightWingLowerPart.m_20359_((Entity)this);
        this.rightWingLowerPart.setParent((Entity)this);
        this.leftWingUpperPart = new EntityDragonPart(this, scale, -90.0f, 0.5f * scale, 0.85f * scale, 0.3f * scale, 0.5f);
        this.leftWingUpperPart.m_20359_((Entity)this);
        this.leftWingUpperPart.setParent((Entity)this);
        this.leftWingLowerPart = new EntityDragonPart(this, 1.4f * scale, -100.0f, 0.3f * scale, 0.85f * scale, 0.2f * scale, 0.5f);
        this.leftWingLowerPart.m_20359_((Entity)this);
        this.leftWingLowerPart.setParent((Entity)this);
        this.tail1Part = new EntityDragonPart(this, -0.75f * scale, 0.0f, 0.6f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail1Part.m_20359_((Entity)this);
        this.tail1Part.setParent((Entity)this);
        this.tail2Part = new EntityDragonPart(this, -1.15f * scale, 0.0f, 0.45f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail2Part.m_20359_((Entity)this);
        this.tail2Part.setParent((Entity)this);
        this.tail3Part = new EntityDragonPart(this, -1.5f * scale, 0.0f, 0.35f * scale, 0.35f * scale, 0.35f * scale, 1.0f);
        this.tail3Part.m_20359_((Entity)this);
        this.tail3Part.setParent((Entity)this);
        this.tail4Part = new EntityDragonPart(this, -1.95f * scale, 0.0f, 0.25f * scale, 0.45f * scale, 0.3f * scale, 1.5f);
        this.tail4Part.m_20359_((Entity)this);
        this.tail4Part.setParent((Entity)this);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.headPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.neckPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.m_142687_(Entity.RemovalReason.DISCARDED);
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.tail1Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.tail2Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.tail3Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.tail4Part.m_142687_(Entity.RemovalReason.DISCARDED);
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.headPart != null) {
            if (!this.headPart.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.headPart);
            }
            this.headPart.setParent((Entity)this);
        }
        if (this.neckPart != null) {
            if (!this.neckPart.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.neckPart);
            }
            this.neckPart.setParent((Entity)this);
        }
        if (this.rightWingUpperPart != null) {
            if (!this.rightWingUpperPart.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.rightWingUpperPart);
            }
            this.rightWingUpperPart.setParent((Entity)this);
        }
        if (this.rightWingLowerPart != null) {
            if (!this.rightWingLowerPart.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.rightWingLowerPart);
            }
            this.rightWingLowerPart.setParent((Entity)this);
        }
        if (this.leftWingUpperPart != null) {
            if (!this.leftWingUpperPart.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.leftWingUpperPart);
            }
            this.leftWingUpperPart.setParent((Entity)this);
        }
        if (this.leftWingLowerPart != null) {
            if (!this.leftWingLowerPart.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.leftWingLowerPart);
            }
            this.leftWingLowerPart.setParent((Entity)this);
        }
        if (this.tail1Part != null) {
            if (!this.tail1Part.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.tail1Part);
            }
            this.tail1Part.setParent((Entity)this);
        }
        if (this.tail2Part != null) {
            if (!this.tail2Part.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.tail2Part);
            }
            this.tail2Part.setParent((Entity)this);
        }
        if (this.tail3Part != null) {
            if (!this.tail3Part.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.tail3Part);
            }
            this.tail3Part.setParent((Entity)this);
        }
        if (this.tail4Part != null) {
            if (!this.tail4Part.shouldContinuePersisting()) {
                this.f_19853_.m_7967_((Entity)this.tail4Part);
            }
            this.tail4Part.setParent((Entity)this);
        }
    }

    protected void updateBurnTarget() {
        if (!(this.burningTarget == null || this.m_5803_() || this.isModelDead() || this.m_6162_())) {
            float maxDist = 115 * this.getDragonStage();
            boolean flag = false;
            if (this.f_19853_.m_7702_(this.burningTarget) instanceof TileEntityDragonforgeInput && ((TileEntityDragonforgeInput)this.f_19853_.m_7702_(this.burningTarget)).isAssembled() && this.m_20275_((double)this.burningTarget.m_123341_() + 0.5, (double)this.burningTarget.m_123342_() + 0.5, (double)this.burningTarget.m_123343_() + 0.5) < (double)maxDist && this.canPositionBeSeen((double)this.burningTarget.m_123341_() + 0.5, (double)this.burningTarget.m_123342_() + 0.5, (double)this.burningTarget.m_123343_() + 0.5)) {
                this.m_21563_().m_24950_((double)this.burningTarget.m_123341_() + 0.5, (double)this.burningTarget.m_123342_() + 0.5, (double)this.burningTarget.m_123343_() + 0.5, 180.0f, 180.0f);
                this.breathFireAtPos(this.burningTarget);
                this.setBreathingFire(true);
            } else {
                if (!this.f_19853_.f_46443_) {
                    IceAndFire.sendMSGToAll(new MessageDragonSetBurnBlock(this.m_142049_(), true, this.burningTarget));
                }
                this.burningTarget = null;
            }
        }
    }

    protected abstract void breathFireAtPos(BlockPos var1);

    protected PathingStuckHandler createStuckHandler() {
        return PathingStuckHandler.createStuckHandler();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.WALKING);
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, this.createStuckHandler());
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler) {
        return this.createNavigator(worldIn, type, stuckHandler, 4.0f, 4.0f);
    }

    protected PathNavigation createNavigator(Level worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler, float width, float height) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((Mob)this, this.f_19853_, type, width, height);
        this.f_21344_ = newNavigator;
        newNavigator.m_7008_(true);
        newNavigator.m_26575_().m_77355_(true);
        return newNavigator;
    }

    protected void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.f_21342_ = new IafDragonFlightManager.GroundMoveHelper((Mob)this);
            this.f_21344_ = this.createNavigator(this.f_19853_, AdvancedPathNavigate.MovementType.WALKING, this.createStuckHandler().withTeleportSteps(5));
            this.navigatorType = 0;
            this.setFlying(false);
            this.setHovering(false);
        } else if (navigatorType == 1) {
            this.f_21342_ = new IafDragonFlightManager.FlightMoveHelper(this);
            this.f_21344_ = this.createNavigator(this.f_19853_, AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 1;
        } else {
            this.f_21342_ = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityDragonBase>(this);
            this.f_21344_ = this.createNavigator(this.f_19853_, AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 2;
        }
    }

    public boolean canBeRiddenInWater(Entity rider) {
        return true;
    }

    protected void m_8024_() {
        super.m_8024_();
        this.breakBlock();
    }

    public boolean canDestroyBlock(BlockPos pos, BlockState state) {
        return state.m_60734_().canEntityDestroy(state, (BlockGetter)this.f_19853_, pos, (Entity)this);
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int m_8085_() {
        return 30 * this.getDragonStage() / 5;
    }

    public void openInventory(Player player) {
        if (!this.f_19853_.f_46443_) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)this.getMenuProvider());
        }
        IceAndFire.PROXY.setReferencedMob((Entity)this);
    }

    public MenuProvider getMenuProvider() {
        return new SimpleMenuProvider((containerId, playerInventory, player) -> new ContainerDragon(containerId, (Container)this.dragonInventory, playerInventory, this), this.m_5446_());
    }

    public int m_8100_() {
        return 90;
    }

    protected void m_6153_() {
        this.f_20919_ = 0;
        this.setModelDead(true);
        this.m_20153_();
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            this.m_142687_(Entity.RemovalReason.KILLED);
            for (int k = 0; k < 40; ++k) {
                double d2 = this.f_19796_.nextGaussian() * 0.02;
                double d0 = this.f_19796_.nextGaussian() * 0.02;
                double d1 = this.f_19796_.nextGaussian() * 0.02;
                if (!this.f_19853_.f_46443_) continue;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), this.m_20186_() + (double)(this.f_19796_.nextFloat() * this.m_20206_()), this.m_20189_() + (double)(this.f_19796_.nextFloat() * this.m_20205_() * 2.0f) - (double)this.m_20205_(), d2, d0, d1);
            }
            this.spawnDeathParticles();
        }
    }

    protected void spawnDeathParticles() {
    }

    protected void spawnBabyParticles() {
    }

    public void m_142687_(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull Entity.RemovalReason reason) {
        this.removeParts();
        super.m_142687_(reason);
    }

    protected int m_6552_(@NotNull Player player) {
        switch (this.getDragonStage()) {
            case 2: {
                return 20;
            }
            case 3: {
                return 150;
            }
            case 4: {
                return 300;
            }
            case 5: {
                return 650;
            }
        }
        return 5;
    }

    public int getArmorOrdinal(ItemStack stack) {
        Item item;
        if (!stack.m_41619_() && (item = stack.m_41720_()) instanceof ItemDragonArmor) {
            ItemDragonArmor armorItem = (ItemDragonArmor)item;
            return armorItem.type.ordinal() + 1;
        }
        return 0;
    }

    public boolean m_21525_() {
        return this.isModelDead() || super.m_21525_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HUNGER, (Object)0);
        this.f_19804_.m_135372_(AGE_TICKS, (Object)0);
        this.f_19804_.m_135372_(GENDER, (Object)false);
        this.f_19804_.m_135372_(VARIANT, (Object)0);
        this.f_19804_.m_135372_(SLEEPING, (Object)false);
        this.f_19804_.m_135372_(FIREBREATHING, (Object)false);
        this.f_19804_.m_135372_(HOVERING, (Object)false);
        this.f_19804_.m_135372_(FLYING, (Object)false);
        this.f_19804_.m_135372_(DEATH_STAGE, (Object)0);
        this.f_19804_.m_135372_(MODEL_DEAD, (Object)false);
        this.f_19804_.m_135372_(CONTROL_STATE, (Object)0);
        this.f_19804_.m_135372_(TACKLE, (Object)false);
        this.f_19804_.m_135372_(AGINGDISABLED, (Object)false);
        this.f_19804_.m_135372_(COMMAND, (Object)0);
        this.f_19804_.m_135372_(DRAGON_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(CRYSTAL_BOUND, (Object)false);
        this.f_19804_.m_135372_(CUSTOM_POSE, (Object)"");
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean isAttacking() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean isStriking() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean isDismounting() {
        return ((Byte)this.f_19804_.m_135370_(CONTROL_STATE) >> 4 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
        if (newState) {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.f_19804_.m_135381_(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.f_19804_.m_135370_(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.f_19804_.m_135381_(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.f_19804_.m_135370_(COMMAND);
    }

    public void setCommand(int command) {
        this.f_19804_.m_135381_(COMMAND, (Object)command);
        this.m_21839_(command == 1);
    }

    public float getDragonPitch() {
        return ((Float)this.f_19804_.m_135370_(DRAGON_PITCH)).floatValue();
    }

    public void setDragonPitch(float pitch) {
        this.f_19804_.m_135381_(DRAGON_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementDragonPitch(float pitch) {
        this.f_19804_.m_135381_(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() + pitch));
    }

    public void decrementDragonPitch(float pitch) {
        this.f_19804_.m_135381_(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() - pitch));
    }

    public void m_7380_(@NotNull CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128405_("Hunger", this.getHunger());
        compound.m_128405_("AgeTicks", this.getAgeInTicks());
        compound.m_128379_("Gender", this.isMale());
        compound.m_128405_("Variant", this.getVariant());
        compound.m_128379_("Sleeping", this.m_5803_());
        compound.m_128379_("TamedDragon", this.m_21824_());
        compound.m_128379_("FireBreathing", this.isBreathingFire());
        compound.m_128379_("AttackDecision", this.usingGroundAttack);
        compound.m_128379_("Hovering", this.isHovering());
        compound.m_128379_("Flying", this.isFlying());
        compound.m_128405_("DeathStage", this.getDeathStage());
        compound.m_128379_("ModelDead", this.isModelDead());
        compound.m_128350_("DeadProg", this.modelDeadProgress);
        compound.m_128379_("Tackle", this.isTackling());
        compound.m_128379_("HasHomePosition", this.hasHomePosition);
        compound.m_128359_("CustomPose", this.getCustomPose());
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(compound);
        }
        compound.m_128379_("AgingDisabled", this.isAgingDisabled());
        compound.m_128405_("Command", this.getCommand());
        if (this.dragonInventory != null) {
            ListTag nbttaglist = new ListTag();
            for (int i = 0; i < this.dragonInventory.m_6643_(); ++i) {
                ItemStack itemstack = this.dragonInventory.m_8020_(i);
                if (itemstack.m_41619_()) continue;
                CompoundTag CompoundNBT = new CompoundTag();
                CompoundNBT.m_128344_("Slot", (byte)i);
                itemstack.m_41739_(CompoundNBT);
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.m_128365_("Items", (Tag)nbttaglist);
        }
        compound.m_128379_("CrystalBound", this.isBoundToCrystal());
        if (this.m_8077_()) {
            compound.m_128359_("CustomName", Component.Serializer.m_130703_((Component)this.m_7770_()));
        }
    }

    public void m_7378_(@NotNull CompoundTag compound) {
        super.m_7378_(compound);
        this.setHunger(compound.m_128451_("Hunger"));
        this.setAgeInTicks(compound.m_128451_("AgeTicks"));
        this.setGender(compound.m_128471_("Gender"));
        this.setVariant(compound.m_128451_("Variant"));
        this.m_21837_(compound.m_128471_("Sleeping"));
        this.m_7105_(compound.m_128471_("TamedDragon"));
        this.setBreathingFire(compound.m_128471_("FireBreathing"));
        this.usingGroundAttack = compound.m_128471_("AttackDecision");
        this.setHovering(compound.m_128471_("Hovering"));
        this.setFlying(compound.m_128471_("Flying"));
        this.setDeathStage(compound.m_128451_("DeathStage"));
        this.setModelDead(compound.m_128471_("ModelDead"));
        this.modelDeadProgress = compound.m_128457_("DeadProg");
        this.setCustomPose(compound.m_128461_("CustomPose"));
        this.hasHomePosition = compound.m_128471_("HasHomePosition");
        if (this.hasHomePosition && compound.m_128451_("HomeAreaX") != 0 && compound.m_128451_("HomeAreaY") != 0 && compound.m_128451_("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(compound, this.f_19853_);
        }
        this.setTackling(compound.m_128471_("Tackle"));
        this.setAgingDisabled(compound.m_128471_("AgingDisabled"));
        this.setCommand(compound.m_128451_("Command"));
        if (this.dragonInventory != null) {
            ListTag nbttaglist = compound.m_128437_("Items", 10);
            this.createInventory();
            for (Tag inbt : nbttaglist) {
                CompoundTag CompoundNBT = (CompoundTag)inbt;
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                if (j > 4) continue;
                this.dragonInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        } else {
            ListTag nbttaglist = compound.m_128437_("Items", 10);
            this.createInventory();
            for (Tag inbt : nbttaglist) {
                CompoundTag CompoundNBT = (CompoundTag)inbt;
                int j = CompoundNBT.m_128445_("Slot") & 0xFF;
                this.dragonInventory.m_6836_(j, ItemStack.m_41712_((CompoundTag)CompoundNBT));
            }
        }
        this.setCrystalBound(compound.m_128471_("CrystalBound"));
        if (compound.m_128425_("CustomName", 8) && !compound.m_128461_("CustomName").startsWith("TextComponent")) {
            this.m_6593_((Component)Component.Serializer.m_130701_((String)compound.m_128461_("CustomName")));
        }
    }

    public int getContainerSize() {
        return 5;
    }

    protected void createInventory() {
        SimpleContainer tempInventory = this.dragonInventory;
        this.dragonInventory = new SimpleContainer(this.getContainerSize());
        if (tempInventory != null) {
            tempInventory.m_19181_((ContainerListener)this);
            int i = Math.min(tempInventory.m_6643_(), this.dragonInventory.m_6643_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = tempInventory.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                this.dragonInventory.m_6836_(j, itemstack.m_41777_());
            }
        }
        this.dragonInventory.m_19164_((ContainerListener)this);
        this.updateContainerEquipment();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.dragonInventory));
    }

    protected void updateContainerEquipment() {
        if (!this.f_19853_.f_46443_) {
            this.updateAttributes();
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (this.m_6084_() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && this.itemHandler != null) {
            return this.itemHandler.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.itemHandler != null) {
            LazyOptional<?> oldHandler = this.itemHandler;
            this.itemHandler = null;
            oldHandler.invalidate();
        }
    }

    public boolean hasInventoryChanged(Container pInventory) {
        return this.dragonInventory != pInventory;
    }

    @Nullable
    public Entity m_6688_() {
        for (Entity passenger : this.m_20197_()) {
            if (!(passenger instanceof Player)) continue;
            Player player = (Player)passenger;
            if (this.m_5448_() == passenger || !this.m_21824_() || this.m_142504_() == null || !this.m_142504_().equals(player.m_142081_())) continue;
            return player;
        }
        return null;
    }

    public boolean isRidingPlayer(Player player) {
        return this.getRidingPlayer() != null && player != null && this.getRidingPlayer().m_142081_().equals(player.m_142081_());
    }

    @Override
    @Nullable
    public Player getRidingPlayer() {
        if (this.m_6688_() instanceof Player) {
            return (Player)this.m_6688_();
        }
        return null;
    }

    protected void updateAttributes() {
        this.prevArmorResLoc = this.armorResLoc;
        int armorHead = this.getArmorOrdinal(this.m_6844_(EquipmentSlot.HEAD));
        int armorNeck = this.getArmorOrdinal(this.m_6844_(EquipmentSlot.CHEST));
        int armorLegs = this.getArmorOrdinal(this.m_6844_(EquipmentSlot.LEGS));
        int armorFeet = this.getArmorOrdinal(this.m_6844_(EquipmentSlot.FEET));
        this.armorResLoc = this.dragonType.getName() + "|" + armorHead + "|" + armorNeck + "|" + armorLegs + "|" + armorFeet;
        IceAndFire.PROXY.updateDragonArmorRender(this.armorResLoc);
        double age = 125.0;
        if (this.getAgeInDays() <= 125) {
            age = this.getAgeInDays();
        }
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        this.m_21051_(Attributes.f_22276_).m_22100_((double)Math.round(this.minimumHealth + healthStep * (double)this.getAgeInDays()));
        this.m_21051_(Attributes.f_22281_).m_22100_((double)Math.round(this.minimumDamage + attackStep * (double)this.getAgeInDays()));
        this.m_21051_(Attributes.f_22279_).m_22100_(this.minimumSpeed + speedStep * (double)this.getAgeInDays());
        double baseValue = this.minimumArmor + armorStep * (double)this.getAgeInDays();
        this.m_21051_(Attributes.f_22284_).m_22100_(baseValue);
        if (!this.f_19853_.f_46443_) {
            this.m_21051_(Attributes.f_22284_).m_22120_(ARMOR_MODIFIER_UUID);
            this.m_21051_(Attributes.f_22284_).m_22125_(new AttributeModifier(ARMOR_MODIFIER_UUID, "Dragon armor bonus", this.calculateArmorModifier(), AttributeModifier.Operation.ADDITION));
        }
        this.m_21051_(Attributes.f_22277_).m_22100_((double)Math.min(2048, IafConfig.dragonTargetSearchLength));
    }

    public int getHunger() {
        return (Integer)this.f_19804_.m_135370_(HUNGER);
    }

    public void setHunger(int hunger) {
        this.f_19804_.m_135381_(HUNGER, (Object)Mth.m_14045_((int)hunger, (int)0, (int)100));
    }

    public int getVariant() {
        return (Integer)this.f_19804_.m_135370_(VARIANT);
    }

    public void setVariant(int variant) {
        this.f_19804_.m_135381_(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return (Integer)this.f_19804_.m_135370_(AGE_TICKS) / 24000;
    }

    public void setAgeInDays(int age) {
        this.f_19804_.m_135381_(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.f_19804_.m_135370_(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.f_19804_.m_135381_(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.f_19804_.m_135370_(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.f_19804_.m_135381_(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.f_19804_.m_135370_(GENDER);
    }

    public boolean isModelDead() {
        if (this.f_19853_.f_46443_) {
            this.isModelDead = (Boolean)this.f_19804_.m_135370_(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.f_19804_.m_135381_(MODEL_DEAD, (Object)modeldead);
        if (!this.f_19853_.f_46443_) {
            this.isModelDead = modeldead;
        }
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.f_19804_.m_135370_(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.f_19804_.m_135381_(HOVERING, (Object)hovering);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.f_19804_.m_135370_(FLYING);
    }

    public void setFlying(boolean flying) {
        this.f_19804_.m_135381_(FLYING, (Object)flying);
    }

    public boolean useFlyingPathFinder() {
        return this.isFlying() && this.m_6688_() == null;
    }

    public void setGender(boolean male) {
        this.f_19804_.m_135381_(GENDER, (Object)male);
    }

    public boolean m_5803_() {
        return (Boolean)this.f_19804_.m_135370_(SLEEPING);
    }

    public boolean isBlinking() {
        return this.f_19797_ % 50 > 43;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.f_19804_.m_135370_(FIREBREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.f_19804_.m_135381_(FIREBREATHING, (Object)breathing);
    }

    protected boolean m_7310_(@NotNull Entity passenger) {
        return this.m_20197_().size() < 2;
    }

    public boolean m_21827_() {
        return ((Byte)this.f_19804_.m_135370_(f_21798_) & 1) != 0;
    }

    public void m_21837_(boolean sleeping) {
        this.f_19804_.m_135381_(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.m_21573_().m_26573_();
        }
    }

    public void m_21839_(boolean sitting) {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_21798_);
        if (sitting) {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 | 1)));
            this.m_21573_().m_26573_();
        } else {
            this.f_19804_.m_135381_(f_21798_, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public String getCustomPose() {
        return (String)this.f_19804_.m_135370_(CUSTOM_POSE);
    }

    public void setCustomPose(String customPose) {
        this.f_19804_.m_135381_(CUSTOM_POSE, (Object)customPose);
        this.modelDeadProgress = 20.0f;
    }

    public void riderShootFire(Entity controller) {
    }

    public void m_5837_(@NotNull ServerLevel world, @NotNull LivingEntity entity) {
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((Entity)entity));
    }

    private double calculateArmorModifier() {
        EquipmentSlot[] slots;
        double val = 1.0;
        block7: for (EquipmentSlot slot : slots = new EquipmentSlot[]{EquipmentSlot.HEAD, EquipmentSlot.CHEST, EquipmentSlot.LEGS, EquipmentSlot.FEET}) {
            switch (this.getArmorOrdinal(this.m_6844_(slot))) {
                case 1: {
                    val += 2.0;
                    continue block7;
                }
                case 2: 
                case 4: {
                    val += 3.0;
                    continue block7;
                }
                case 3: {
                    val += 5.0;
                    continue block7;
                }
                case 5: 
                case 6: 
                case 8: {
                    val += 10.0;
                    continue block7;
                }
                case 7: {
                    val += 1.5;
                }
            }
        }
        return val;
    }

    public boolean canMove() {
        return !this.m_21827_() && !this.m_5803_() && this.m_6688_() == null && !this.m_20159_() && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean isFuelingForge() {
        return this.burningTarget != null && this.f_19853_.m_7702_(this.burningTarget) instanceof TileEntityDragonforgeInput;
    }

    public boolean m_6084_() {
        if (this.isModelDead()) {
            return !this.m_146910_();
        }
        return super.m_6084_();
    }

    @NotNull
    public InteractionResult m_7111_(Player player, @NotNull Vec3 vec, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int lastDeathStage = Math.min(this.getAgeInDays() / 5, 25);
        if (stack.m_41720_() == IafItemRegistry.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return InteractionResult.SUCCESS;
        }
        if (this.isModelDead() && this.getDeathStage() < lastDeathStage && player.m_36326_()) {
            if (!this.f_19853_.f_46443_ && !stack.m_41619_() && stack.m_41720_() != null && stack.m_41720_() == Items.f_42590_ && this.getDeathStage() < lastDeathStage / 2 && IafConfig.dragonDropBlood) {
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.setDeathStage(this.getDeathStage() + 1);
                player.m_150109_().m_36054_(new ItemStack((ItemLike)this.getBloodItem(), 1));
                return InteractionResult.SUCCESS;
            }
            if (!this.f_19853_.f_46443_ && stack.m_41619_() && IafConfig.dragonDropSkull) {
                if (this.getDeathStage() >= lastDeathStage - 1) {
                    ItemStack skull = this.getSkull().m_41777_();
                    skull.m_41751_(new CompoundTag());
                    skull.m_41783_().m_128405_("Stage", this.getDragonStage());
                    skull.m_41783_().m_128405_("DragonType", 0);
                    skull.m_41783_().m_128405_("DragonAge", this.getAgeInDays());
                    this.setDeathStage(this.getDeathStage() + 1);
                    if (!this.f_19853_.f_46443_) {
                        this.m_5552_(skull, 1.0f);
                    }
                    this.m_142687_(Entity.RemovalReason.DISCARDED);
                } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && IafConfig.dragonDropHeart) {
                    ItemStack heart = new ItemStack(this.getHeartItem(), 1);
                    ItemStack egg = new ItemStack((ItemLike)this.getVariantEgg(this.f_19796_.nextInt(4)), 1);
                    if (!this.f_19853_.f_46443_) {
                        this.m_5552_(heart, 1.0f);
                        if (!this.isMale() && this.getDragonStage() > 3) {
                            this.m_5552_(egg, 1.0f);
                        }
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                } else {
                    this.setDeathStage(this.getDeathStage() + 1);
                    ItemStack drop = this.getRandomDrop();
                    if (!drop.m_41619_() && !this.f_19853_.f_46443_) {
                        this.m_5552_(drop, 1.0f);
                    }
                }
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_7111_(player, vec, hand);
    }

    @NotNull
    public InteractionResult m_6071_(Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        int lastDeathStage = this.getAgeInDays() / 5;
        if (stack.m_41720_() == IafItemRegistry.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return InteractionResult.SUCCESS;
        }
        if (!this.isModelDead()) {
            if (stack.m_41720_() == IafItemRegistry.CREATIVE_DRAGON_MEAL.get()) {
                this.m_7105_(true);
                this.m_21828_(player);
                this.setHunger(this.getHunger() + 20);
                this.m_5634_(Math.min(this.m_21223_(), (float)((int)(this.m_21233_() / 2.0f))));
                this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                this.spawnItemCrackParticles(stack.m_41720_());
                this.spawnItemCrackParticles(Items.f_42500_);
                this.spawnItemCrackParticles(Items.f_42499_);
                this.eatFoodBonus(stack);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.m_6898_(stack) && this.m_6125_()) {
                this.m_146762_(0);
                this.m_142075_(player, InteractionHand.MAIN_HAND, stack);
                this.m_27595_(player);
                return InteractionResult.SUCCESS;
            }
            if (this.m_21830_((LivingEntity)player)) {
                if (stack.m_41720_() == this.getSummoningCrystal() && !ItemSummoningCrystal.hasDragon(stack)) {
                    this.setCrystalBound(true);
                    CompoundTag compound = stack.m_41783_();
                    if (compound == null) {
                        compound = new CompoundTag();
                        stack.m_41751_(compound);
                    }
                    CompoundTag dragonTag = new CompoundTag();
                    dragonTag.m_128362_("DragonUUID", this.m_142081_());
                    if (this.m_7770_() != null) {
                        dragonTag.m_128359_("CustomName", this.m_7770_().getString());
                    }
                    compound.m_128365_("Dragon", (Tag)dragonTag);
                    this.m_5496_(SoundEvents.f_11771_, 1.0f, 1.0f);
                    player.m_6674_(hand);
                    return InteractionResult.SUCCESS;
                }
                this.m_21828_(player);
                if (stack.m_41720_() == IafItemRegistry.DRAGON_HORN.get()) {
                    return super.m_6071_(player, hand);
                }
                if (stack.m_41619_() && !player.m_6144_()) {
                    if (!this.f_19853_.f_46443_) {
                        int dragonStage = this.getDragonStage();
                        if (dragonStage < 2) {
                            if (player.m_20197_().size() >= 3) {
                                return InteractionResult.FAIL;
                            }
                            this.m_7998_((Entity)player, true);
                            IceAndFire.sendMSGToAll(new MessageStartRidingMob(this.m_142049_(), true, true));
                        } else if (dragonStage > 2 && !player.m_20159_()) {
                            player.m_20260_(false);
                            player.m_7998_((Entity)this, true);
                            IceAndFire.sendMSGToAll(new MessageStartRidingMob(this.m_142049_(), true, false));
                            this.m_21837_(false);
                        }
                        this.m_21573_().m_26573_();
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stack.m_41619_() && player.m_6144_()) {
                    this.openInventory(player);
                    return InteractionResult.SUCCESS;
                }
                int itemFoodAmount = FoodUtils.getFoodPoints(stack, true, this.dragonType.isPiscivore());
                if (itemFoodAmount > 0 && (this.getHunger() < 100 || this.m_21223_() < this.m_21233_())) {
                    this.setHunger(this.getHunger() + itemFoodAmount);
                    this.m_21153_(Math.min(this.m_21233_(), (float)((int)(this.m_21223_() + (float)(itemFoodAmount / 10)))));
                    this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                    this.spawnItemCrackParticles(stack.m_41720_());
                    this.eatFoodBonus(stack);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                Item stackItem = stack.m_41720_();
                if (stackItem == IafItemRegistry.DRAGON_MEAL.get()) {
                    this.growDragon(1);
                    this.setHunger(this.getHunger() + 20);
                    this.m_5634_(Math.min(this.m_21223_(), (float)((int)(this.m_21233_() / 2.0f))));
                    this.m_5496_(SoundEvents.f_11912_, this.m_6121_(), this.m_6100_());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.f_42500_);
                    this.spawnItemCrackParticles(Items.f_42499_);
                    this.eatFoodBonus(stack);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackItem == IafItemRegistry.SICKLY_DRAGON_MEAL.get() && !this.isAgingDisabled()) {
                    this.setHunger(this.getHunger() + 20);
                    this.m_5634_(this.m_21233_());
                    this.m_5496_(SoundEvents.f_12644_, this.m_6121_(), this.m_6100_());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(Items.f_42500_);
                    this.spawnItemCrackParticles(Items.f_42499_);
                    this.spawnItemCrackParticles(Items.f_42675_);
                    this.spawnItemCrackParticles(Items.f_42675_);
                    this.setAgingDisabled(true);
                    this.eatFoodBonus(stack);
                    if (!player.m_7500_()) {
                        stack.m_41774_(1);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (stackItem == IafItemRegistry.DRAGON_STAFF.get()) {
                    if (player.m_6144_()) {
                        if (this.hasHomePosition) {
                            this.hasHomePosition = false;
                            player.m_5661_((Component)new TranslatableComponent("dragon.command.remove_home"), true);
                            return InteractionResult.SUCCESS;
                        }
                        BlockPos pos = this.m_142538_();
                        this.homePos = new HomePosition(pos, this.f_19853_);
                        this.hasHomePosition = true;
                        player.m_5661_((Component)new TranslatableComponent("dragon.command.new_home", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), this.homePos.getDimension()}), true);
                        return InteractionResult.SUCCESS;
                    }
                    this.m_5496_(SoundEvents.f_12609_, this.m_6121_(), this.m_6100_());
                    if (!this.f_19853_.f_46443_) {
                        this.setCommand(this.getCommand() + 1);
                        if (this.getCommand() > 2) {
                            this.setCommand(0);
                        }
                    }
                    String commandText = "stand";
                    if (this.getCommand() == 1) {
                        commandText = "sit";
                    } else if (this.getCommand() == 2) {
                        commandText = "escort";
                    }
                    player.m_5661_((Component)new TranslatableComponent("dragon.command." + commandText), true);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return super.m_6071_(player, hand);
    }

    protected abstract ItemLike getHeartItem();

    protected abstract Item getBloodItem();

    protected ItemStack getSkull() {
        return ItemStack.f_41583_;
    }

    private ItemStack getRandomDrop() {
        ItemStack stack = this.getItemFromLootTable();
        if (stack.m_41720_() == IafItemRegistry.DRAGON_BONE.get()) {
            this.m_5496_(SoundEvents.f_12423_, 1.0f, 1.0f);
        } else {
            this.m_5496_(SoundEvents.f_11678_, 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean canPositionBeSeen(double x, double y, double z) {
        BlockHitResult result = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.m_20185_(), this.m_20186_() + (double)this.m_20192_(), this.m_20189_()), new Vec3(x, y, z), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        double dist = result.m_82450_().m_82531_(x, y, z);
        return dist <= 1.0 || result.m_6662_() == HitResult.Type.MISS;
    }

    public abstract ResourceLocation getDeadLootTable();

    public ItemStack getItemFromLootTable() {
        LootContext.Builder lootcontext$builder;
        LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(this.getDeadLootTable());
        Iterator iterator = loottable.m_79129_((lootcontext$builder = this.m_7771_(false, DamageSource.f_19318_)).m_78975_(LootContextParamSets.f_81415_)).iterator();
        if (iterator.hasNext()) {
            ItemStack itemstack = (ItemStack)iterator.next();
            return itemstack;
        }
        return ItemStack.f_41583_;
    }

    public void eatFoodBonus(ItemStack stack) {
    }

    public boolean m_8023_() {
        return true;
    }

    public boolean m_21532_() {
        return true;
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.m_20011_(this.m_142469_());
        if (this.f_19853_.f_46443_ && this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                float f = (float)((double)this.m_21187_().nextFloat() * (this.m_142469_().f_82291_ - this.m_142469_().f_82288_) + this.m_142469_().f_82288_);
                float f1 = (float)((double)this.m_21187_().nextFloat() * (this.m_142469_().f_82292_ - this.m_142469_().f_82289_) + this.m_142469_().f_82289_);
                float f2 = (float)((double)this.m_21187_().nextFloat() * (this.m_142469_().f_82293_ - this.m_142469_().f_82290_) + this.m_142469_().f_82290_);
                double motionX = this.m_21187_().nextGaussian() * 0.07;
                double motionY = this.m_21187_().nextGaussian() * 0.07;
                double motionZ = this.m_21187_().nextGaussian() * 0.07;
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123748_, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ);
                ++i;
            }
        }
        if (this.getDragonStage() >= 2) {
            this.m_6038_();
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(Item item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.m_21187_().nextGaussian() * 0.07;
            double motionY = this.m_21187_().nextGaussian() * 0.07;
            double motionZ = this.m_21187_().nextGaussian() * 0.07;
            Vec3 headVec = this.getHeadPosition();
            if (!this.f_19853_.f_46443_) {
                ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)item)), headVec.f_82479_, headVec.f_82480_, headVec.f_82481_, 1, motionX, motionY, motionZ, 0.1);
                continue;
            }
            this.f_19853_.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, new ItemStack((ItemLike)item)), headVec.f_82479_, headVec.f_82480_, headVec.f_82481_, motionX, motionY, motionZ);
        }
    }

    public boolean isTimeToWake() {
        return this.f_19853_.m_46461_() || this.getCommand() == 2;
    }

    private boolean isStuck() {
        return !this.isChained() && !this.m_21824_() && !this.m_21573_().m_26571_() && (this.m_21573_().m_26570_() == null || this.m_21573_().m_26570_().m_77395_() != null && this.m_20275_(this.m_21573_().m_26570_().m_77395_().f_77271_, this.m_21573_().m_26570_().m_77395_().f_77272_, this.m_21573_().m_26570_().m_77395_().f_77273_) > 15.0) && this.ticksStill > 80 && !this.isHovering() && this.canMove();
    }

    protected boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.f_19853_.m_46859_(new BlockPos(this.m_20185_(), this.m_142469_().f_82289_ - 1.0, this.m_20189_()));
    }

    public boolean isDiving() {
        return false;
    }

    public boolean isBeyondHeight() {
        if (this.m_20186_() > (double)this.f_19853_.m_151558_()) {
            return true;
        }
        return this.m_20186_() > (double)IafConfig.maxDragonFlight;
    }

    private int calculateDownY() {
        if (this.m_21573_().m_26570_() != null) {
            Path path = this.m_21573_().m_26570_();
            Vec3 p = path.m_77382_((Entity)this, Math.min(path.m_77398_() - 1, path.m_77399_() + 1));
            if (p.f_82480_ < this.m_20186_() - 1.0) {
                return -1;
            }
        }
        return 1;
    }

    public void breakBlock() {
        if (this.blockBreakCounter > 0 || IafConfig.dragonBreakBlockCooldown == 0) {
            --this.blockBreakCounter;
            if (!(this.isIceInWater() || this.blockBreakCounter != 0 && IafConfig.dragonBreakBlockCooldown != 0 || !ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) || IafConfig.dragonGriefing == 2 || this.m_21824_() && !IafConfig.tamedDragonGriefing || this.isModelDead() || this.getDragonStage() < 3 || !this.canMove() && this.m_6688_() == null)) {
                boolean bounds = true;
                int flightModifier = this.isFlying() && this.m_5448_() != null ? -1 : 1;
                int yMinus = this.calculateDownY();
                BlockPos.m_121886_((int)((int)Math.floor(this.m_142469_().f_82288_) - 1), (int)((int)Math.floor(this.m_142469_().f_82289_) + yMinus), (int)((int)Math.floor(this.m_142469_().f_82290_) - 1), (int)((int)Math.floor(this.m_142469_().f_82291_) + 1), (int)((int)Math.floor(this.m_142469_().f_82292_) + 1 + flightModifier), (int)((int)Math.floor(this.m_142469_().f_82293_) + 1)).forEach(pos -> {
                    float hardness;
                    if (MinecraftForge.EVENT_BUS.post((Event)new GenericGriefEvent((LivingEntity)this, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()))) {
                        return;
                    }
                    BlockState state = this.f_19853_.m_8055_(pos);
                    float f = hardness = IafConfig.dragonGriefing == 1 || this.getDragonStage() <= 3 ? 2.0f : 5.0f;
                    if (this.isBreakable((BlockPos)pos, state, hardness)) {
                        this.m_20256_(this.m_20184_().m_82542_((double)0.6f, 1.0, (double)0.6f));
                        if (!this.f_19853_.f_46443_) {
                            if ((double)this.f_19796_.nextFloat() <= IafConfig.dragonBlockBreakingDropChance && DragonUtils.canDropFromDragonBlockBreak(state)) {
                                this.f_19853_.m_46961_(pos, true);
                            } else {
                                this.f_19853_.m_46597_(pos, Blocks.f_50016_.m_49966_());
                            }
                        }
                    }
                });
            }
        }
    }

    protected boolean isBreakable(BlockPos pos, BlockState state, float hardness) {
        return state.m_60767_().m_76334_() && !state.m_60795_() && state.m_60819_().m_76178_() && !state.m_60808_((BlockGetter)this.f_19853_, pos).m_83281_() && state.m_60800_((BlockGetter)this.f_19853_, pos) >= 0.0f && state.m_60800_((BlockGetter)this.f_19853_, pos) <= hardness && DragonUtils.canDragonBreak(state.m_60734_()) && this.canDestroyBlock(pos, state);
    }

    @Override
    public boolean isBlockExplicitlyPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        if (!this.isModelDead() && this.getDragonStage() >= 3 && IafConfig.dragonGriefing != 2 && (!this.m_21824_() || IafConfig.tamedDragonGriefing) && (double)pos.m_123342_() >= this.m_20186_()) {
            return this.isBreakable(pos, state, IafConfig.dragonGriefing == 1 || this.getDragonStage() <= 3 ? 2.0f : 5.0f);
        }
        return false;
    }

    @Override
    public boolean isBlockExplicitlyNotPassable(BlockState state, BlockPos pos, BlockPos entityPos) {
        return false;
    }

    protected boolean isIceInWater() {
        return false;
    }

    public void spawnGroundEffects() {
        if (this.f_19853_.f_46443_) {
            int i = 0;
            while ((float)i < this.getRenderSize()) {
                for (int i1 = 0; i1 < 20; ++i1) {
                    float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * this.f_20883_ + (float)i1 * 1.0f;
                    double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
                    double extraY = 0.8f;
                    double extraZ = radius * Mth.m_14089_((float)angle);
                    BlockPos ground = this.getGround(new BlockPos(Mth.m_14107_((double)(this.m_20185_() + extraX)), Mth.m_14107_((double)(this.m_20186_() + (double)0.8f)) - 1, Mth.m_14107_((double)(this.m_20189_() + extraZ))));
                    BlockState BlockState2 = this.f_19853_.m_8055_(ground);
                    if (BlockState2.m_60767_() == Material.f_76296_) continue;
                    double motionX = this.m_21187_().nextGaussian() * 0.07;
                    double motionY = this.m_21187_().nextGaussian() * 0.07;
                    double motionZ = this.m_21187_().nextGaussian() * 0.07;
                    this.f_19853_.m_6493_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, BlockState2), true, this.m_20185_() + extraX, (double)ground.m_123342_() + (double)0.8f, this.m_20189_() + extraZ, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }

    private BlockPos getGround(BlockPos blockPos) {
        while (this.f_19853_.m_46859_(blockPos) && blockPos.m_123342_() > 1) {
            blockPos = blockPos.m_7495_();
        }
        return blockPos;
    }

    public void fall(float distance, float damageMultiplier) {
    }

    public boolean isActuallyBreathingFire() {
        return this.fireTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.isGoingDown() || this.flyTicks > 40 && this.flyProgress == 0.0f || this.isChained() && this.flyTicks > 100;
    }

    public abstract String getVariantName(int var1);

    public boolean shouldRiderSit() {
        return this.m_6688_() != null;
    }

    public void m_7332_(@NotNull Entity passenger) {
        super.m_7332_(passenger);
        if (this.m_20363_(passenger)) {
            if (this.m_6688_() == null || !this.m_6688_().m_142081_().equals(passenger.m_142081_())) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.m_8127_();
                }
                this.m_146922_(passenger.m_146908_());
                this.m_5616_(passenger.m_6080_());
                this.m_146926_(passenger.m_146909_());
                Vec3 riderPos = this.getRiderPosition();
                passenger.m_6034_(riderPos.f_82479_, riderPos.f_82480_ + (double)passenger.m_20206_(), riderPos.f_82481_);
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        double a = Mth.m_14031_((float)(f * speed)) * f1 * degree;
        float bob = (float)(a - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(a));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    protected void updatePreyInMouth(Entity prey) {
        if (this.getAnimation() != ANIMATION_SHAKEPREY) {
            this.setAnimation(ANIMATION_SHAKEPREY);
        }
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            prey.m_6469_(DamageSource.m_19370_((LivingEntity)this), prey instanceof Player ? 17.0f : (float)this.m_21051_(Attributes.f_22281_).m_22135_() * 4.0f);
            prey.m_8127_();
        }
        this.f_20883_ = this.m_146908_();
        float modTick_0 = this.getAnimationTick() - 25;
        float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * Mth.m_14036_((float)Mth.m_14031_((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
        float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
        float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
        float angle = (float)Math.PI / 180 * this.f_20883_ + 3.15f + modTick_1 * 2.0f * 0.015f;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        double extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
        prey.m_6034_(this.m_20185_() + extraX, this.m_20186_() + extraY, this.m_20189_() + extraZ);
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() < 4 && this.getDragonStage() > 2;
    }

    public boolean m_6125_() {
        return this.getDragonStage() >= 4;
    }

    public boolean m_6162_() {
        return this.getDragonStage() < 2;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor worldIn, @NotNull DifficultyInstance difficultyIn, @NotNull MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setGender(this.m_21187_().nextBoolean());
        int age = this.m_21187_().nextInt(80) + 1;
        this.growDragon(age);
        this.setVariant(new Random().nextInt(4));
        this.m_21837_(false);
        this.updateAttributes();
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.m_5634_(Math.round(this.minimumHealth + healthStep * (double)age));
        this.usingGroundAttack = true;
        this.setHunger(50);
        return spawnDataIn;
    }

    public boolean m_6469_(@NotNull DamageSource dmg, float i) {
        if (this.isModelDead() && dmg != DamageSource.f_19317_) {
            return false;
        }
        if (this.m_20160_() && dmg.m_7639_() != null && this.m_6688_() != null && dmg.m_7639_() == this.m_6688_()) {
            return false;
        }
        if ((dmg.f_19326_.contains("arrow") || this.m_20202_() != null && dmg.m_7639_() != null && dmg.m_7639_().m_7306_(this.m_20202_())) && this.m_20159_()) {
            return false;
        }
        if (dmg == DamageSource.f_19310_ || dmg == DamageSource.f_19322_ || dmg == DamageSource.f_19311_) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && dmg.m_7639_() != null && this.m_21187_().nextInt(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.m_5803_()) {
            this.m_21837_(false);
            if (!this.m_21824_() && dmg.m_7639_() instanceof Player) {
                this.m_6710_((LivingEntity)((Player)dmg.m_7639_()));
            }
        }
        return super.m_6469_(dmg, i);
    }

    public void m_6210_() {
        super.m_6210_();
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        if (scale != this.lastScale) {
            this.resetParts(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    public float getStepHeight() {
        return Math.max(1.2f, 1.2f + (float)(Math.min(this.getAgeInDays(), 125) - 25) * 1.8f / 100.0f);
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6210_();
        this.updateParts();
        this.prevDragonPitch = this.getDragonPitch();
        this.f_19853_.m_46473_().m_6180_("dragonLogic");
        this.f_19793_ = this.getStepHeight();
        this.isOverAir = this.isOverAirLogic();
        this.logic.updateDragonCommon();
        if (this.isModelDead()) {
            if (!this.f_19853_.f_46443_ && this.f_19853_.m_46859_(new BlockPos(this.m_20185_(), this.m_142469_().f_82289_, this.m_20189_())) && this.m_20186_() > -1.0) {
                this.m_6478_(MoverType.SELF, new Vec3(0.0, (double)-0.2f, 0.0));
            }
            this.setBreathingFire(false);
            float dragonPitch = this.getDragonPitch();
            if (dragonPitch > 0.0f) {
                dragonPitch = Math.min(0.0f, dragonPitch - 5.0f);
                this.setDragonPitch(dragonPitch);
            }
            if (dragonPitch < 0.0f) {
                this.setDragonPitch(Math.max(0.0f, dragonPitch + 5.0f));
            }
        } else if (this.f_19853_.f_46443_) {
            this.logic.updateDragonClient();
        } else {
            this.logic.updateDragonServer();
            this.logic.updateDragonAttack();
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("dragonFlight");
        if (this.useFlyingPathFinder() && !this.f_19853_.f_46443_ && this.m_6109_()) {
            this.flightManager.update();
        }
        this.f_19853_.m_46473_().m_7238_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.prevModelDeadProgress = this.modelDeadProgress;
        this.prevDiveProgress = this.diveProgress;
        this.prevAnimationProgresses[0] = this.sitProgress;
        this.prevAnimationProgresses[1] = this.sleepProgress;
        this.prevAnimationProgresses[2] = this.hoverProgress;
        this.prevAnimationProgresses[3] = this.flyProgress;
        this.prevAnimationProgresses[4] = this.fireBreathProgress;
        this.prevAnimationProgresses[5] = this.ridingProgress;
        this.prevAnimationProgresses[6] = this.tackleProgress;
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL && this.m_5448_() instanceof Player) {
            this.m_6710_(null);
        }
        if (this.isModelDead()) {
            if (this.m_20160_()) {
                this.m_20153_();
            }
            this.setHovering(false);
            this.setFlying(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
        if (this.animationTick > this.getAnimation().getDuration() && !this.f_19853_.f_46443_) {
            this.animationTick = 0;
        }
    }

    @NotNull
    public EntityDimensions m_6972_(@NotNull Pose poseIn) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    public float m_6134_() {
        return Math.min(this.getRenderSize() * 0.35f, 7.0f);
    }

    protected void m_7840_(double y, boolean onGroundIn, @NotNull BlockState state, @NotNull BlockPos pos) {
    }

    public float getRenderSize() {
        int stage = this.getDragonStage() - 1;
        float step = (this.growth_stages[stage][1] - this.growth_stages[stage][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return this.growth_stages[stage][0] + step * 25.0f;
        }
        return this.growth_stages[stage][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean m_7327_(@NotNull Entity entityIn) {
        this.m_21563_().m_24960_(entityIn, 30.0f, 30.0f);
        if (this.isTackling() || this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), (float)((int)this.m_21051_(Attributes.f_22281_).m_22135_()));
        if (flag) {
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public void m_6083_() {
        Entity entity = this.m_20202_();
        if (this.m_20159_() && !entity.m_6084_()) {
            this.m_8127_();
        } else {
            this.m_20334_(0.0, 0.0, 0.0);
            this.m_8119_();
            if (this.m_20159_()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(Entity riding) {
        if (riding != null && riding.m_20363_((Entity)this) && riding instanceof Player) {
            int i = riding.m_20197_().indexOf(this);
            float radius = (i == 2 ? -0.2f : 0.5f) + (float)(((Player)riding).m_21255_() ? 2 : 0);
            float angle = (float)Math.PI / 180 * ((Player)riding).f_20883_ + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * Mth.m_14089_((float)angle);
            double extraY = (riding.m_6144_() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.f_20885_ = ((Player)riding).f_20885_;
            this.m_146922_(((Player)riding).f_20885_);
            this.m_6034_(riding.m_20185_() + extraX, riding.m_20186_() + extraY, riding.m_20189_() + extraZ);
            if ((this.getControlState() == 16 || ((Player)riding).m_21255_()) && !riding.m_20159_()) {
                this.m_8127_();
                if (this.f_19853_.f_46443_) {
                    IceAndFire.sendMSGToServer(new MessageStartRidingMob(this.m_142049_(), false, true));
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void m_8032_() {
        if (!(this.m_5803_() || this.isModelDead() || this.f_19853_.f_46443_)) {
            if (this.getAnimation() == NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.m_8032_();
        }
    }

    protected void m_6677_(@NotNull DamageSource source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == NO_ANIMATION && !this.f_19853_.f_46443_) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.m_6677_(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public AgeableMob m_142606_(@NotNull ServerLevel serverWorld, @NotNull AgeableMob ageable) {
        return null;
    }

    public boolean m_7848_(@NotNull Animal otherAnimal) {
        if (otherAnimal instanceof EntityDragonBase) {
            EntityDragonBase dragon = (EntityDragonBase)otherAnimal;
            if (otherAnimal != this && otherAnimal.getClass() == this.getClass()) {
                return this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale();
            }
        }
        return false;
    }

    public EntityDragonEgg createEgg(EntityDragonBase ageable) {
        EntityDragonEgg dragon = new EntityDragonEgg((EntityType)IafEntityRegistry.DRAGON_EGG.get(), this.f_19853_);
        dragon.setEggType(EnumDragonEgg.byMetadata(new Random().nextInt(4) + this.getStartMetaForType()));
        dragon.m_6034_((double)Mth.m_14107_((double)this.m_20185_()) + 0.5, Mth.m_14107_((double)this.m_20186_()) + 1, (double)Mth.m_14107_((double)this.m_20189_()) + 0.5);
        return dragon;
    }

    public int getStartMetaForType() {
        return 0;
    }

    public boolean isTargetBlocked(Vec3 target) {
        if (target != null) {
            BlockHitResult rayTrace = this.f_19853_.m_45547_(new ClipContext(this.m_20182_().m_82520_(0.0, (double)this.m_20192_(), 0.0), target, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
            BlockPos sidePos = rayTrace.m_82425_();
            if (!this.f_19853_.m_46859_(sidePos)) {
                return true;
            }
            if (!this.f_19853_.m_46859_(new BlockPos(rayTrace.m_82450_()))) {
                return true;
            }
            return rayTrace.m_6662_() == HitResult.Type.BLOCK;
        }
        return false;
    }

    private double getFlySpeed() {
        return (2 + this.getAgeInDays() / 125 * 2) * (this.isTackling() ? 2 : 1);
    }

    public boolean isTackling() {
        return (Boolean)this.f_19804_.m_135370_(TACKLE);
    }

    public void setTackling(boolean tackling) {
        this.f_19804_.m_135381_(TACKLE, (Object)tackling);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.f_19804_.m_135370_(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.f_19804_.m_135381_(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.f_19804_.m_135370_(CRYSTAL_BOUND);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.f_19804_.m_135381_(CRYSTAL_BOUND, (Object)crystalBound);
    }

    public float getDistanceSquared(Vec3 Vector3d) {
        float f = (float)(this.m_20185_() - Vector3d.f_82479_);
        float f1 = (float)(this.m_20186_() - Vector3d.f_82480_);
        float f2 = (float)(this.m_20189_() - Vector3d.f_82481_);
        return f * f + f1 * f1 + f2 * f2;
    }

    public abstract Item getVariantScale(int var1);

    public abstract Item getVariantEgg(int var1);

    public abstract Item getSummoningCrystal();

    public boolean m_6109_() {
        return super.m_6109_();
    }

    public boolean m_5807_() {
        return true;
    }

    public boolean m_6107_() {
        return this.m_21223_() <= 0.0f || this.m_21827_() && !this.m_20160_() || this.isModelDead() || this.m_20159_();
    }

    public boolean m_20069_() {
        return super.m_20069_() && this.m_204036_(FluidTags.f_13131_) > (double)Mth.m_14143_((float)((float)this.getDragonStage() / 2.0f));
    }

    public void m_7023_(@NotNull Vec3 pTravelVector) {
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.m_20160_() || this.m_21827_()) {
            if (this.m_21573_().m_26570_() != null) {
                this.m_21573_().m_26573_();
            }
            pTravelVector = new Vec3(0.0, 0.0, 0.0);
        }
        if (this.allowLocalMotionControl && this.m_6688_() != null && this.m_5807_()) {
            LivingEntity rider = (LivingEntity)this.m_6688_();
            if (rider == null) {
                super.m_7023_(pTravelVector);
                return;
            }
            if (this.isHovering() || this.isFlying()) {
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_;
                double vertical = 0.0;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                float airSpeedModifier = (float)((double)5.2f + 1.0 * Mth.m_144914_((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                speed *= airSpeedModifier;
                if (forward > 0.0) {
                    this.setFlying(true);
                    this.setHovering(false);
                }
                if (this.isAttacking() && this.m_146909_() > -5.0f && this.m_20184_().m_82553_() > 1.0) {
                    this.setTackling(true);
                } else {
                    this.setTackling(false);
                }
                boolean bl = this.gliding = this.allowMousePitchControl && rider.m_20142_();
                if (!this.gliding) {
                    speed += this.glidingSpeedBonus;
                    forward *= rider.f_20902_ > 0.0f ? 1.0 : 0.5;
                    strafing *= (double)0.4f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 1.0;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -1.0;
                    } else if (this.m_6109_()) {
                        // empty if block
                    }
                } else {
                    speed *= 1.5f;
                    strafing *= (double)0.1f;
                    this.glidingSpeedBonus = (float)Mth.m_14008_((double)((double)this.glidingSpeedBonus + this.m_20184_().f_82480_ * -0.05), (double)-0.8, (double)1.5);
                    speed += this.glidingSpeedBonus;
                    forward = Mth.m_14154_((float)Mth.m_14089_((float)(this.m_146909_() * ((float)Math.PI / 180))));
                    vertical = Mth.m_14154_((float)Mth.m_14031_((float)(this.m_146909_() * ((float)Math.PI / 180))));
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = Math.max(vertical, 0.5);
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = Math.min(vertical, -0.5);
                    } else if (this.isGoingUp() && this.isGoingDown()) {
                        vertical = 0.0;
                    } else if (this.m_146909_() < 0.0f) {
                        vertical *= 1.0;
                    } else if (this.m_146909_() > 0.0f) {
                        vertical *= -1.0;
                    } else if (this.m_6109_()) {
                        // empty if block
                    }
                }
                this.glidingSpeedBonus = (float)((double)this.glidingSpeedBonus - (double)this.glidingSpeedBonus * 0.01);
                if (this.m_6109_()) {
                    this.f_20887_ = speed * 0.1f;
                    this.m_7910_(speed);
                    this.m_19920_(this.f_20887_, new Vec3(strafing, vertical, forward));
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                    this.m_20256_(this.m_20184_().m_82559_(new Vec3(0.9, 0.9, 0.9)));
                    Vec3 currentMotion = this.m_20184_();
                    if (this.f_19862_) {
                        currentMotion = new Vec3(currentMotion.f_82479_, 0.1, currentMotion.f_82481_);
                    }
                    this.m_20256_(currentMotion);
                    this.m_21043_((LivingEntity)this, false);
                } else {
                    this.m_20256_(Vec3.f_82478_);
                }
                this.m_146872_();
                this.updatePitch(this.f_19791_ - this.m_20186_());
                return;
            }
            if (this.m_20069_() || this.m_20077_()) {
                double forward = rider.f_20902_;
                double strafing = rider.f_20900_;
                double vertical = 0.0;
                float speed = (float)this.m_21133_(Attributes.f_22279_);
                if (this.isGoingUp() && !this.isGoingDown()) {
                    vertical = 0.5;
                } else if (this.isGoingDown() && !this.isGoingUp()) {
                    vertical = -0.5;
                }
                this.f_20887_ = speed;
                this.m_7910_(speed);
                this.m_21564_((float)forward);
                super.m_7023_(pTravelVector.m_82520_(strafing, vertical, forward));
                return;
            }
            double forward = rider.f_20902_;
            double strafing = rider.f_20900_;
            double vertical = pTravelVector.f_82480_;
            float speed = (float)this.m_21133_(Attributes.f_22279_);
            float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
            forward *= (double)(speed *= groundSpeedModifier);
            forward *= rider.m_20142_() ? (double)1.2f : 1.0;
            forward *= rider.f_20902_ > 0.0f ? 1.0 : (double)0.2f;
            strafing *= (double)0.05f;
            if (this.m_6109_()) {
                this.f_20887_ = speed * 0.1f;
                this.m_7910_(speed);
                super.m_7023_(new Vec3(strafing, vertical, forward));
            } else {
                this.m_20256_(Vec3.f_82478_);
            }
            this.m_146872_();
            this.updatePitch(this.f_19791_ - this.m_20186_());
            return;
        }
        super.m_7023_(pTravelVector);
    }

    protected void updatePitch(double verticalDelta) {
        if (this.isOverAir() && !this.m_20159_()) {
            if (!this.isHovering()) {
                this.incrementDragonPitch((float)verticalDelta * 10.0f);
            }
            this.setDragonPitch(Mth.m_14036_((float)this.getDragonPitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            float planeDist = (float)((Math.abs(this.m_20184_().f_82479_) + Math.abs(this.m_20184_().f_82481_)) * 6.0);
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(1.0f);
            } else if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(1.0f);
            }
            if (this.m_6688_() == null && this.getDragonPitch() < -45.0f && planeDist < 3.0f && this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
        } else if (Mth.m_14154_((float)this.getDragonPitch()) < 1.0f) {
            this.setDragonPitch(0.0f);
        } else {
            this.setDragonPitch(this.getDragonPitch() / 1.5f);
        }
    }

    public void updateRider() {
        Entity controllingPassenger = this.m_6688_();
        if (controllingPassenger instanceof Player) {
            Player rider = (Player)controllingPassenger;
            this.ticksStill = 0;
            this.hoverTicks = 0;
            this.flyTicks = 0;
            if (this.isGoingUp()) {
                if (!this.isFlying() && !this.isHovering()) {
                    this.spacebarTicks += 2;
                }
            } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.setCommand(2);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.m_142480_() != null && this.m_20197_().contains(this.m_142480_()) && !this.isFlying() && !this.isHovering() && !this.m_20069_()) {
                this.setHovering(true);
                this.spacebarTicks = 0;
                this.glidingSpeedBonus = 0.0f;
            }
            if (this.isFlying() || this.isHovering()) {
                if (rider.f_20902_ > 0.0f) {
                    this.setFlying(true);
                    this.setHovering(false);
                } else {
                    this.setFlying(false);
                    this.setHovering(true);
                }
                if (!this.isOverAir() && this.isFlying() && rider.m_146909_() > 10.0f && !this.m_20069_()) {
                    this.setHovering(false);
                    this.setFlying(false);
                }
                if (!this.isOverAir() && this.isGoingDown() && !this.m_20069_()) {
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (this.isTackling()) {
                ++this.tacklingTicks;
                if (this.tacklingTicks == 40) {
                    this.tacklingTicks = 0;
                }
                if (!this.isFlying() && this.m_20096_()) {
                    this.tacklingTicks = 0;
                    this.setTackling(false);
                }
                List victims = this.f_19853_.m_6249_((Entity)this, this.m_142469_().m_82363_(2.0, 2.0, 2.0), potentialVictim -> potentialVictim != rider && potentialVictim instanceof LivingEntity);
                victims.forEach(victim -> this.logic.attackTarget((Entity)victim, rider, this.getDragonStage() * 3));
            }
            if (this.isStriking() && this.m_6688_() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire(this.m_6688_());
                this.fireStopTicks = 10;
            }
            if (this.isAttacking() && this.m_6688_() != null && this.m_6688_() instanceof Player) {
                LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((Player)this.m_6688_()), (double)this.getDragonStage() + (this.m_142469_().f_82291_ - this.m_142469_().f_82288_));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (Entity)target)) {
                    this.logic.attackTarget((Entity)target, (Player)(rider instanceof Player ? rider : null), (int)this.m_21051_(Attributes.f_22281_).m_22135_());
                }
            }
            if (this.m_6688_() != null && this.m_6688_().m_6144_()) {
                if (this.m_6688_() instanceof LivingEntity) {
                    MiscProperties.setDismountedDragon((LivingEntity)this.m_6688_(), true);
                }
                this.m_6688_().m_8127_();
            }
            if (this.m_5448_() != null && !this.m_20197_().isEmpty() && this.m_142480_() != null && this.m_20197_().contains(this.m_142480_())) {
                this.m_6710_(null);
            }
            if (this.m_146900_().m_60819_().m_76170_() && this.m_20069_() && !this.isGoingUp()) {
                this.setFlying(false);
                this.setHovering(false);
            }
        } else if (controllingPassenger instanceof EntityDreadQueen) {
            Player ridingPlayer = this.getRidingPlayer();
            if (ridingPlayer != null) {
                if (this.isGoingUp()) {
                    if (!this.isFlying() && !this.isHovering()) {
                        this.spacebarTicks += 2;
                    }
                } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (!this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, 0.01, 0.0));
            }
            if (this.isStriking() && this.m_6688_() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire(this.m_6688_());
                this.fireStopTicks = 10;
            }
            if (this.isAttacking() && this.m_6688_() != null && this.m_6688_() instanceof Player) {
                LivingEntity target = DragonUtils.riderLookingAtEntity((LivingEntity)this, (LivingEntity)((Player)this.m_6688_()), (double)this.getDragonStage() + (this.m_142469_().f_82291_ - this.m_142469_().f_82288_));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (Entity)target)) {
                    this.logic.attackTarget((Entity)target, ridingPlayer, (int)this.m_21051_(Attributes.f_22281_).m_22135_());
                }
            }
            if (this.m_6688_() != null && this.m_6688_().m_6144_()) {
                if (this.m_6688_() instanceof LivingEntity) {
                    MiscProperties.setDismountedDragon((LivingEntity)this.m_6688_(), true);
                }
                this.m_6688_().m_8127_();
            }
            if (this.isFlying()) {
                if (!this.isHovering() && this.m_6688_() != null && !this.m_20096_() && Math.max(Math.abs(this.m_20184_().m_7096_()), Math.abs(this.m_20184_().m_7094_())) < (double)0.1f) {
                    this.setHovering(true);
                    this.setFlying(false);
                }
            } else if (this.isHovering() && this.m_6688_() != null && !this.m_20096_() && Math.max(Math.abs(this.m_20184_().m_7096_()), Math.abs(this.m_20184_().m_7094_())) > (double)0.1f) {
                this.setFlying(true);
                this.usingGroundAttack = false;
                this.setHovering(false);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.m_142480_() != null && this.m_20197_().contains(this.m_142480_()) && !this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
            if (this.m_20160_() && !this.isOverAir() && this.isFlying() && !this.isHovering() && this.flyTicks > 40) {
                this.setFlying(false);
            }
        }
    }

    public void m_20256_(Vec3 pMotion) {
        super.m_20256_(pMotion);
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pPos) {
        if (this.m_21827_() && !this.m_20160_()) {
            pPos = new Vec3(0.0, pPos.m_7098_(), 0.0);
        }
        if (this.m_20160_()) {
            if (this.m_6109_()) {
                if (this.f_19862_) {
                    this.m_20256_(this.m_20184_().m_82542_((double)0.6f, 1.0, (double)0.6f));
                }
                super.m_6478_(pType, pPos);
            } else {
                this.f_19794_ = true;
                super.m_6478_(pType, pPos);
            }
            if (this.isHovering() || this.isFlying()) {
                this.m_20242_(true);
            } else {
                this.m_20242_(false);
            }
        } else {
            this.f_19794_ = false;
            this.m_20242_(false);
            super.m_6478_(pType, pPos);
        }
    }

    public void updateCheckPlayer() {
        double checkLength = this.m_142469_().m_82309_() * 3.0;
        Player player = this.f_19853_.m_45930_((Entity)this, checkLength);
        if (this.m_5803_() && player != null && !this.m_21830_((LivingEntity)player) && !player.m_7500_()) {
            this.m_21837_(false);
            this.m_21839_(false);
            this.m_6710_((LivingEntity)player);
        }
    }

    public boolean shouldDismountInWater(Entity rider) {
        return false;
    }

    public boolean isDirectPathBetweenPoints(Vec3 vec1, Vec3 vec2) {
        BlockHitResult rayTrace = this.f_19853_.m_45547_(new ClipContext(vec1, new Vec3(vec2.f_82479_, vec2.f_82480_ + (double)this.m_20206_() * 0.5, vec2.f_82481_), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return rayTrace.m_6662_() != HitResult.Type.BLOCK;
    }

    public void m_6667_(@NotNull DamageSource cause) {
        super.m_6667_(cause);
    }

    @Override
    public void onHearFlute(Player player) {
        if (this.m_21824_() && this.m_21830_((LivingEntity)player) && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    public abstract SoundEvent getRoarSound();

    public void roar() {
        block9: {
            block8: {
                if (EntityGorgon.isStoneMob((LivingEntity)this) || this.isModelDead()) {
                    return;
                }
                if (!this.f_19796_.nextBoolean()) break block8;
                if (this.getAnimation() != ANIMATION_EPIC_ROAR) {
                    this.setAnimation(ANIMATION_EPIC_ROAR);
                    this.m_5496_(this.getRoarSound(), this.m_6121_() + 3.0f + (float)Math.max(0, this.getDragonStage() - 2), this.m_6100_() * 0.7f);
                }
                if (this.getDragonStage() <= 3) break block9;
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82363_((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (isStrongerDragon) continue;
                    if (this.m_21830_(living) || this.isOwnersPet(living)) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 50 * size));
                        continue;
                    }
                    if (living.m_6844_(EquipmentSlot.HEAD).m_41720_() == IafItemRegistry.EARPLUGS.get()) continue;
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 50 * size));
                }
                break block9;
            }
            if (this.getAnimation() != ANIMATION_ROAR) {
                this.setAnimation(ANIMATION_ROAR);
                this.m_5496_(this.getRoarSound(), this.m_6121_() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.m_6100_());
            }
            if (this.getDragonStage() > 3) {
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82363_((double)size, (double)size, (double)size));
                for (Entity entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity;
                    if (isStrongerDragon) continue;
                    if (this.m_21830_(living) || this.isOwnersPet(living)) {
                        living.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 30 * size));
                        continue;
                    }
                    living.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 30 * size));
                }
            }
        }
    }

    private boolean isOwnersPet(LivingEntity living) {
        return this.m_21824_() && this.m_142480_() != null && living instanceof TamableAnimal && ((TamableAnimal)living).m_142480_() != null && this.m_142480_().m_7306_((Entity)((TamableAnimal)living).m_142480_());
    }

    public boolean isDirectPathBetweenPoints(Entity entity, Vec3 vec1, Vec3 vec2) {
        BlockHitResult movingobjectposition = this.f_19853_.m_45547_(new ClipContext(vec1, vec2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
        return movingobjectposition.m_6662_() != HitResult.Type.BLOCK;
    }

    public boolean shouldRenderEyes() {
        return !this.m_5803_() && !this.isModelDead() && !this.isBlinking() && !EntityGorgon.isStoneMob((LivingEntity)this);
    }

    @Override
    public boolean shouldAnimalsFear(Entity entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
    }

    public boolean isChained() {
        return ChainProperties.hasChainData((LivingEntity)this);
    }

    protected void m_7625_(@NotNull DamageSource damageSourceIn, boolean attackedRecently) {
    }

    public HitResult rayTraceRider(Entity rider, double blockReachDistance, float partialTicks) {
        Vec3 Vector3d = rider.m_20299_(partialTicks);
        Vec3 Vector3d1 = rider.m_20252_(partialTicks);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * blockReachDistance, Vector3d1.f_82480_ * blockReachDistance, Vector3d1.f_82481_ * blockReachDistance);
        return this.f_19853_.m_45547_(new ClipContext(Vector3d, Vector3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this));
    }

    protected float getRideHeightBase() {
        return 0.00223789f * Mth.m_14207_((float)this.getRenderSize()) + 0.23313718f * this.getRenderSize() + -1.7179043f;
    }

    protected float getRideHorizontalBase() {
        return 0.00336283f * Mth.m_14207_((float)this.getRenderSize()) + 0.19342425f * this.getRenderSize() + -0.026221339f;
    }

    public Vec3 getRiderPosition() {
        float extraXZ = 0.0f;
        float extraY = 0.0f;
        float pitchXZ = 0.0f;
        float pitchY = 0.0f;
        float dragonPitch = this.getDragonPitch();
        if (dragonPitch > 0.0f) {
            pitchXZ = Math.min(dragonPitch / 90.0f, 0.2f);
            pitchY = -(dragonPitch / 90.0f) * 0.6f;
        } else if (dragonPitch < 0.0f) {
            pitchXZ = Math.max(dragonPitch / 90.0f, -0.5f);
            pitchY = dragonPitch / 90.0f * 0.03f;
        }
        extraXZ += pitchXZ * this.getRenderSize();
        extraY += pitchY * this.getRenderSize();
        float linearFactor = Mth.m_184637_((float)Math.max(this.getAgeInDays() - 50, 0), (float)0.0f, (float)75.0f, (float)0.0f, (float)1.0f);
        Entity entity = this.m_6688_();
        if (entity instanceof LivingEntity) {
            LivingEntity rider = (LivingEntity)entity;
            if (rider.m_146909_() < 0.0f) {
                extraY = (float)((double)extraY + Mth.m_144914_((double)rider.m_146909_(), (double)60.0, (double)-40.0, (double)-0.1, (double)0.1));
            }
            if (this.isHovering() || this.isFlying()) {
                extraY += 1.1f * linearFactor;
                extraY += this.getRideHeightBase() * 0.6f;
            } else {
                if (rider.f_20902_ > 0.0f) {
                    float MAX_RAISE_HEIGHT = 1.1f * linearFactor + this.getRideHeightBase() * 0.1f;
                    this.riderWalkingExtraY = Math.min(MAX_RAISE_HEIGHT, this.riderWalkingExtraY + 0.1f);
                } else {
                    this.riderWalkingExtraY = Math.max(0.0f, this.riderWalkingExtraY - 0.15f);
                }
                extraY += this.riderWalkingExtraY;
            }
        }
        float xzMod = this.getRideHorizontalBase() + extraXZ;
        float yMod = this.getRideHeightBase() + extraY;
        float headPosX = (float)(this.m_20185_() + (double)(xzMod * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.m_20186_() + (double)yMod);
        float headPosZ = (float)(this.m_20189_() + (double)(xzMod * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        return new Vec3((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public Vec3 m_7688_(LivingEntity pPassenger) {
        return this.getRiderPosition().m_82520_(0.0, (double)pPassenger.m_20206_(), 0.0);
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        this.setDeathStage(this.getAgeInDays() / 5);
        this.setModelDead(false);
    }

    public boolean m_7307_(@NotNull Entity entityIn) {
        if (this.isModelDead()) {
            return true;
        }
        if (this.m_21824_()) {
            LivingEntity livingentity = this.m_142480_();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TamableAnimal) {
                return ((TamableAnimal)entityIn).m_21830_(livingentity);
            }
            if (livingentity != null) {
                return livingentity.m_7307_(entityIn);
            }
        }
        return super.m_7307_(entityIn);
    }

    public Vec3 getHeadPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        int tick = 0;
        tick = this.getAnimationTick() < 10 ? this.getAnimationTick() : (this.getAnimationTick() > 50 ? 60 - this.getAnimationTick() : 10);
        float epicRoarProg = this.getAnimation() == ANIMATION_EPIC_ROAR ? (float)tick * 0.1f : 0.0f;
        float sleepProg = this.sleepProgress * -0.025f;
        float pitchMulti = 0.0f;
        float pitchAdjustment = 0.0f;
        float pitchMinus = 0.0f;
        float dragonPitch = -this.getDragonPitch();
        if (this.isFlying() || this.isHovering()) {
            pitchMulti = Mth.m_14031_((float)((float)Math.toRadians(dragonPitch)));
            pitchAdjustment = 1.2f;
            if ((pitchMulti *= 2.1f * Math.abs(dragonPitch) / 90.0f) > 0.0f) {
                pitchMulti *= 1.5f - pitchMulti * 0.5f;
            }
            if (pitchMulti < 0.0f) {
                pitchMulti *= 1.3f - pitchMulti * 0.1f;
            }
            pitchMinus = 0.3f * Math.abs(dragonPitch / 90.0f);
            if (dragonPitch >= 0.0f) {
                pitchAdjustment = 0.6f * Math.abs(dragonPitch / 90.0f);
                pitchMinus = 0.95f * Math.abs(dragonPitch / 90.0f);
            }
        }
        float flightXz = 1.0f + flyProg + hoverProg;
        float xzMod = 1.7f * this.getRenderSize() * 0.3f * flightXz + this.getRenderSize() * (0.3f * Mth.m_14031_((float)((float)((double)(dragonPitch + 90.0f) * Math.PI / 180.0))) * pitchAdjustment - pitchMinus - hoverProg * 0.45f);
        float headPosX = (float)(this.m_20185_() + (double)(xzMod * Mth.m_14089_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.m_20186_() + (double)((0.7f + sitProg + hoverProg + deadProg + epicRoarProg + sleepProg + flyProg + pitchMulti) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.m_20189_() + (double)(xzMod * Mth.m_14031_((float)((float)((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0)))));
        return new Vec3((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public abstract void stimulateFire(double var1, double var3, double var5, int var7);

    public void randomizeAttacks() {
        this.airAttack = IafDragonAttacks.Air.values()[this.m_21187_().nextInt(IafDragonAttacks.Air.values().length)];
        this.groundAttack = IafDragonAttacks.Ground.values()[this.m_21187_().nextInt(IafDragonAttacks.Ground.values().length)];
    }

    public boolean m_7349_(@NotNull Explosion explosionIn, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, BlockState blockStateIn, float explosionPower) {
        return !(blockStateIn.m_60734_() instanceof IDragonProof) && DragonUtils.canDragonBreak(blockStateIn.m_60734_());
    }

    public void tryScorchTarget() {
        LivingEntity entity = this.m_5448_();
        if (entity != null) {
            float distX = (float)(entity.m_20185_() - this.m_20185_());
            float distZ = (float)(entity.m_20189_() - this.m_20189_());
            if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.m_146922_(this.f_20883_);
                    if (this.f_19797_ % 5 == 0) {
                        this.m_5496_(IafSoundRegistry.FIREDRAGON_BREATH, 4.0f, 1.0f);
                    }
                    this.stimulateFire(this.m_20185_() + (double)(distX * (float)this.fireTicks / 40.0f), entity.m_20186_(), this.m_20189_() + (double)(distZ * (float)this.fireTicks / 40.0f), 1);
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }

    public void m_6710_(@Nullable LivingEntity LivingEntityIn) {
        super.m_6710_(LivingEntityIn);
        this.flightManager.onSetAttackTarget(LivingEntityIn);
    }

    public boolean m_7757_(@NotNull LivingEntity target, @NotNull LivingEntity owner) {
        TamableAnimal tamableTarget;
        UUID targetOwner;
        if (this.m_21824_() && target instanceof TamableAnimal && (targetOwner = (tamableTarget = (TamableAnimal)target).m_142504_()) != null && targetOwner.equals(this.m_142504_())) {
            return false;
        }
        return super.m_7757_(target, owner);
    }

    public boolean m_6779_(@NotNull LivingEntity target) {
        return super.m_6779_(target) && DragonUtils.isAlive(target);
    }

    public boolean isPart(Entity entityHit) {
        return this.headPart != null && this.headPart.m_7306_(entityHit) || this.neckPart != null && this.neckPart.m_7306_(entityHit) || this.leftWingLowerPart != null && this.leftWingLowerPart.m_7306_(entityHit) || this.rightWingLowerPart != null && this.rightWingLowerPart.m_7306_(entityHit) || this.leftWingUpperPart != null && this.leftWingUpperPart.m_7306_(entityHit) || this.rightWingUpperPart != null && this.rightWingUpperPart.m_7306_(entityHit) || this.tail1Part != null && this.tail1Part.m_7306_(entityHit) || this.tail2Part != null && this.tail2Part.m_7306_(entityHit) || this.tail3Part != null && this.tail3Part.m_7306_(entityHit) || this.tail4Part != null && this.tail4Part.m_7306_(entityHit);
    }

    @Override
    public double getFlightSpeedModifier() {
        return IafConfig.dragonFlightSpeedMod;
    }

    public boolean isAllowedToTriggerFlight() {
        return (this.hasFlightClearance() && this.f_19861_ || this.m_20069_()) && !this.m_21827_() && this.m_20197_().isEmpty() && !this.m_6162_() && !this.m_5803_() && this.canMove();
    }

    public BlockPos getEscortPosition() {
        return this.m_142480_() != null ? new BlockPos(this.m_142480_().m_20182_()) : this.m_142538_();
    }

    public boolean shouldTPtoOwner() {
        return this.m_142480_() != null && this.m_20270_((Entity)this.m_142480_()) > 10.0f;
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_20223_(@NotNull CompoundTag compound) {
        return this.m_20086_(compound);
    }

    public void m_5496_(@NotNull SoundEvent soundIn, float volume, float pitch) {
        if (soundIn == SoundEvents.f_11912_ || soundIn == this.m_7515_() || soundIn == this.m_7975_(null) || soundIn == this.m_5592_() || soundIn == this.getRoarSound()) {
            if (!this.m_20067_() && this.headPart != null) {
                this.f_19853_.m_6263_(null, this.headPart.m_20185_(), this.headPart.m_20186_(), this.headPart.m_20189_(), soundIn, this.m_5720_(), volume, pitch);
            }
        } else {
            super.m_5496_(soundIn, volume, pitch);
        }
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public boolean hasFlightClearance() {
        BlockPos topOfBB = new BlockPos(this.m_20185_(), this.m_142469_().f_82292_, this.m_20189_());
        for (int i = 1; i < 4; ++i) {
            if (this.f_19853_.m_46859_(topOfBB.m_6630_(i))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_6844_(EquipmentSlot slotIn) {
        switch (slotIn) {
            case OFFHAND: {
                return this.dragonInventory.m_8020_(0);
            }
            case HEAD: {
                return this.dragonInventory.m_8020_(1);
            }
            case CHEST: {
                return this.dragonInventory.m_8020_(2);
            }
            case LEGS: {
                return this.dragonInventory.m_8020_(3);
            }
            case FEET: {
                return this.dragonInventory.m_8020_(4);
            }
        }
        return super.m_6844_(slotIn);
    }

    public void m_8061_(EquipmentSlot slotIn, @NotNull ItemStack stack) {
        switch (slotIn) {
            case OFFHAND: {
                this.dragonInventory.m_6836_(0, stack);
                break;
            }
            case HEAD: {
                this.dragonInventory.m_6836_(1, stack);
                break;
            }
            case CHEST: {
                this.dragonInventory.m_6836_(2, stack);
                break;
            }
            case LEGS: {
                this.dragonInventory.m_6836_(3, stack);
                break;
            }
            case FEET: {
                this.dragonInventory.m_6836_(4, stack);
                break;
            }
            default: {
                super.m_6844_(slotIn);
            }
        }
    }

    public SoundEvent getBabyFireSound() {
        return SoundEvents.f_11937_;
    }

    protected boolean isPlayingAttackAnimation() {
        return this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_SHAKEPREY || this.getAnimation() == ANIMATION_WINGBLAST || this.getAnimation() == ANIMATION_TAILWHACK;
    }

    protected IafDragonLogic createDragonLogic() {
        return new IafDragonLogic(this);
    }

    protected int getFlightChancePerTick() {
        return 1500;
    }

    public void onRemovedFromWorld() {
        DragonPosWorldData data;
        if (IafConfig.chunkLoadSummonCrystal && this.isBoundToCrystal() && (data = DragonPosWorldData.get(this.f_19853_)) != null) {
            data.addDragon(this.m_142081_(), this.m_142538_());
        }
        super.onRemovedFromWorld();
    }

    @Override
    public int maxSearchNodes() {
        return (int)this.m_21051_(Attributes.f_22277_).m_22135_();
    }

    @Override
    public boolean isSmallerThanBlock() {
        return false;
    }

    @Override
    public float getXZNavSize() {
        return Math.max(1.4f, this.m_20205_() / 2.0f);
    }

    @Override
    public int getYNavSize() {
        return Mth.m_14167_((float)this.m_20206_());
    }

    public void m_5757_(@NotNull Container invBasic) {
        if (!this.f_19853_.f_46443_) {
            this.updateAttributes();
        }
    }

    @NotNull
    public Vec3 m_21074_(@NotNull Vec3 pDeltaMovement, float pFriction) {
        if (this.f_21342_ instanceof IafDragonFlightManager.PlayerFlightMoveHelper) {
            return pDeltaMovement;
        }
        return super.m_21074_(pDeltaMovement, pFriction);
    }
}

