/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.pathfinding;

import com.github.alexthe666.iceandfire.IceAndFire;
import com.github.alexthe666.iceandfire.client.render.pathfinding.MRenderTypes;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.MNode;
import com.github.alexthe666.iceandfire.pathfinding.raycoms.Pathfinding;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import java.util.ConcurrentModificationException;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderBuffers;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class RenderPath {
    public static final RenderBuffers renderBuffers = new RenderBuffers();
    private static final MultiBufferSource.BufferSource renderBuffer = renderBuffers.m_110104_();
    public static final Supplier<VertexConsumer> BORDER_LINE_RENDERER = () -> renderBuffer.m_6299_(MRenderTypes.customLineRenderer());
    public static final Supplier<VertexConsumer> PATH_RENDERER = () -> renderBuffer.m_6299_(MRenderTypes.customPathRenderer());
    public static final Supplier<VertexConsumer> PATH_TEXT_RENDERER = () -> renderBuffer.m_6299_(MRenderTypes.customPathTextRenderer());

    public static void debugDraw(double frame, PoseStack matrixStack) {
        if (Pathfinding.lastDebugNodesNotVisited.isEmpty() || Pathfinding.lastDebugNodesPath.isEmpty() || Pathfinding.lastDebugNodesVisited.isEmpty()) {
            return;
        }
        Vec3 vec = Minecraft.m_91087_().m_91290_().f_114358_.m_90583_();
        double dx = vec.m_7096_();
        double dy = vec.m_7098_();
        double dz = vec.m_7094_();
        matrixStack.m_85836_();
        matrixStack.m_85837_(-dx, -dy, -dz);
        try {
            for (MNode n : Pathfinding.lastDebugNodesNotVisited) {
                RenderPath.debugDrawNode(n, 1.0f, 0.0f, 0.0f, matrixStack);
            }
            for (MNode n : Pathfinding.lastDebugNodesVisited) {
                RenderPath.debugDrawNode(n, 0.0f, 0.0f, 1.0f, matrixStack);
            }
            for (MNode n : Pathfinding.lastDebugNodesPath) {
                if (n.isReachedByWorker()) {
                    RenderPath.debugDrawNode(n, 1.0f, 0.4f, 0.0f, matrixStack);
                    continue;
                }
                RenderPath.debugDrawNode(n, 0.0f, 1.0f, 0.0f, matrixStack);
            }
        }
        catch (ConcurrentModificationException exc) {
            IceAndFire.LOGGER.catching((Throwable)exc);
        }
        matrixStack.m_85849_();
    }

    private static void debugDrawNode(MNode n, float r, float g, float b, PoseStack matrixStack) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)n.pos.m_123341_() + 0.375, (double)n.pos.m_123342_() + 0.375, (double)n.pos.m_123343_() + 0.375);
        Entity entity = Minecraft.m_91087_().m_91288_();
        double dx = (double)n.pos.m_123341_() - entity.m_20185_();
        double dy = (double)n.pos.m_123342_() - entity.m_20186_();
        double dz = (double)n.pos.m_123343_() - entity.m_20189_();
        if (Math.sqrt(dx * dx + dy * dy + dz * dz) <= 5.0) {
            RenderPath.renderDebugText(n, matrixStack);
        }
        matrixStack.m_85841_(0.25f, 0.25f, 0.25f);
        VertexConsumer vertexBuffer = PATH_RENDERER.get();
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 1.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 0.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 0.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, 1.0f, 0.0f, 1.0f).m_85950_(r, g, b, 1.0f).m_5752_();
        if (n.parent != null) {
            matrixStack.m_85836_();
            Matrix4f lineMatrix = matrixStack.m_85850_().m_85861_();
            float pdx = (float)(n.parent.pos.m_123341_() - n.pos.m_123341_()) + 0.125f;
            float pdy = (float)(n.parent.pos.m_123342_() - n.pos.m_123342_()) + 0.125f;
            float pdz = (float)(n.parent.pos.m_123343_() - n.pos.m_123343_()) + 0.125f;
            VertexConsumer buffer = BORDER_LINE_RENDERER.get();
            buffer.m_85982_(lineMatrix, 0.5f, 0.5f, 0.5f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
            buffer.m_85982_(lineMatrix, pdx / 0.25f, pdy / 0.25f, pdz / 0.25f).m_85950_(0.75f, 0.75f, 0.75f, 1.0f).m_5752_();
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    private static void renderDebugText(MNode n, PoseStack matrixStack) {
        String s1 = String.format("F: %.3f [%d]", n.getCost(), n.getCounterAdded());
        String s2 = String.format("G: %.3f [%d]", n.getScore(), n.getCounterVisited());
        Font fontrenderer = Minecraft.m_91087_().f_91062_;
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.0, 0.75, 0.0);
        EntityRenderDispatcher renderManager = Minecraft.m_91087_().m_91290_();
        matrixStack.m_85845_(renderManager.m_114470_());
        matrixStack.m_85841_(-0.014f, -0.014f, 0.014f);
        matrixStack.m_85837_(0.0, 18.0, 0.0);
        int i = Math.max(fontrenderer.m_92895_(s1), fontrenderer.m_92895_(s2)) / 2;
        Matrix4f matrix4f = matrixStack.m_85850_().m_85861_();
        VertexConsumer vertexBuffer = PATH_TEXT_RENDERER.get();
        vertexBuffer.m_85982_(matrix4f, (float)(-i - 1), -5.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(-i - 1), 12.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(i + 1), 12.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        vertexBuffer.m_85982_(matrix4f, (float)(i + 1), -5.0f, 0.0f).m_85950_(0.0f, 0.0f, 0.0f, 0.7f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
        matrixStack.m_85836_();
        Matrix4f textMatrix4f = matrixStack.m_85850_().m_85861_();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        matrixStack.m_85837_(0.0, -5.0, (double)-0.1f);
        fontrenderer.m_92811_(s1, (float)(-fontrenderer.m_92895_(s1)) / 2.0f, 0.0f, -1, false, textMatrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        matrixStack.m_85837_(0.0, 8.0, (double)-0.1f);
        fontrenderer.m_92811_(s2, (float)(-fontrenderer.m_92895_(s2)) / 2.0f, 0.0f, -1, false, textMatrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        matrixStack.m_85837_(0.0, -8.0, (double)-0.1f);
        fontrenderer.m_92811_(s1, (float)(-fontrenderer.m_92895_(s1)) / 2.0f, 0.0f, -1, false, textMatrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        matrixStack.m_85837_(0.0, 8.0, (double)-0.1f);
        fontrenderer.m_92811_(s2, (float)(-fontrenderer.m_92895_(s2)) / 2.0f, 0.0f, -1, false, textMatrix4f, (MultiBufferSource)buffer, false, 0, 0xF000F0);
        buffer.m_109911_();
        matrixStack.m_85849_();
        matrixStack.m_85849_();
    }
}

