/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity;

import com.github.alexthe666.iceandfire.client.model.ModelGhost;
import com.github.alexthe666.iceandfire.client.render.IafRenderType;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameplateEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;

public class RenderGhost
extends MobRenderer<EntityGhost, ModelGhost> {
    public static final ResourceLocation TEXTURE_0 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_white.png");
    public static final ResourceLocation TEXTURE_1 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_blue.png");
    public static final ResourceLocation TEXTURE_2 = new ResourceLocation("iceandfire:textures/models/ghost/ghost_green.png");
    public static final ResourceLocation TEXTURE_SHOPPING_LIST = new ResourceLocation("iceandfire:textures/models/ghost/haunted_shopping_list.png");

    public RenderGhost(EntityRendererProvider.Context renderManager) {
        super(renderManager, (EntityModel)new ModelGhost(0.0f), 0.55f);
    }

    public static ResourceLocation getGhostOverlayForType(int ghost) {
        switch (ghost) {
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case -1: {
                return TEXTURE_SHOPPING_LIST;
            }
        }
        return TEXTURE_0;
    }

    public void render(@NotNull EntityGhost entityIn, float entityYaw, float partialTicks, @NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn) {
        RenderType rendertype;
        Direction direction;
        boolean shouldSit;
        this.f_114477_ = 0.0f;
        if (MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn))) {
            return;
        }
        matrixStackIn.m_85836_();
        ((ModelGhost)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entityIn, partialTicks);
        ((ModelGhost)this.f_115290_).f_102609_ = shouldSit = entityIn.m_20159_() && entityIn.m_20202_() != null && entityIn.m_20202_().shouldRiderSit();
        ((ModelGhost)this.f_115290_).f_102610_ = entityIn.m_6162_();
        float f = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20884_, (float)entityIn.f_20883_);
        float f1 = Mth.m_14189_((float)partialTicks, (float)entityIn.f_20886_, (float)entityIn.f_20885_);
        float f2 = f1 - f;
        if (shouldSit && entityIn.m_20202_() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entityIn.m_20202_();
            f = Mth.m_14189_((float)partialTicks, (float)livingentity.f_20884_, (float)livingentity.f_20883_);
            f2 = f1 - f;
            float f3 = Mth.m_14177_((float)f2);
            if (f3 < -85.0f) {
                f3 = -85.0f;
            }
            if (f3 >= 85.0f) {
                f3 = 85.0f;
            }
            f = f1 - f3;
            if (f3 * f3 > 2500.0f) {
                f += f3 * 0.2f;
            }
            f2 = f1 - f;
        }
        float f6 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_19860_, (float)entityIn.m_146909_());
        if (entityIn.m_20089_() == Pose.SLEEPING && (direction = entityIn.m_21259_()) != null) {
            float f4 = entityIn.m_20236_(Pose.STANDING) - 0.1f;
            matrixStackIn.m_85837_((double)((float)(-direction.m_122429_()) * f4), 0.0, (double)((float)(-direction.m_122431_()) * f4));
        }
        float f7 = this.m_6930_((LivingEntity)entityIn, partialTicks);
        this.m_7523_((LivingEntity)entityIn, matrixStackIn, f7, f, partialTicks);
        matrixStackIn.m_85841_(-1.0f, -1.0f, 1.0f);
        this.scale(entityIn, matrixStackIn, partialTicks);
        matrixStackIn.m_85837_(0.0, (double)-1.501f, 0.0);
        float f8 = 0.0f;
        float f5 = 0.0f;
        if (!shouldSit && entityIn.m_6084_()) {
            f8 = Mth.m_14179_((float)partialTicks, (float)entityIn.f_20923_, (float)entityIn.f_20924_);
            f5 = entityIn.f_20925_ - entityIn.f_20924_ * (1.0f - partialTicks);
            if (entityIn.m_6162_()) {
                f5 *= 3.0f;
            }
            if (f8 > 1.0f) {
                f8 = 1.0f;
            }
        }
        ((ModelGhost)this.f_115290_).m_6839_((Entity)entityIn, f5, f8, partialTicks);
        ((ModelGhost)this.f_115290_).setupAnim(entityIn, f5, f8, f7, f2, f6);
        float alphaForRender = this.getAlphaForRender(entityIn, partialTicks);
        RenderType renderType = rendertype = entityIn.isDaytimeMode() ? IafRenderType.getGhostDaytime(this.getTextureLocation(entityIn)) : IafRenderType.getGhost(this.getTextureLocation(entityIn));
        if (rendertype != null && !entityIn.m_20145_()) {
            VertexConsumer ivertexbuilder = bufferIn.m_6299_(rendertype);
            int i = RenderGhost.m_115338_((LivingEntity)entityIn, (float)this.m_6931_((LivingEntity)entityIn, partialTicks));
            if (entityIn.isHauntedShoppingList()) {
                matrixStackIn.m_85836_();
                matrixStackIn.m_85837_(0.0, (double)(0.8f + Mth.m_14031_((float)(((float)entityIn.f_19797_ + partialTicks) * 0.15f)) * 0.1f), 0.0);
                matrixStackIn.m_85841_(0.6f, 0.6f, 0.6f);
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrixStackIn.m_85836_();
                PoseStack.Pose matrixstack$entry = matrixStackIn.m_85850_();
                Matrix4f matrix4f = matrixstack$entry.m_85861_();
                Matrix3f matrix3f = matrixstack$entry.m_85864_();
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, -2, 0, 1.0f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, -2, 0, 0.5f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, 2, 0, 0.5f, 1.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, 2, 0, 1.0f, 1.0f, 0, 1, 0, 240);
                matrixStackIn.m_85849_();
                matrixStackIn.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrixStackIn.m_85836_();
                matrixstack$entry = matrixStackIn.m_85850_();
                matrix4f = matrixstack$entry.m_85861_();
                matrix3f = matrixstack$entry.m_85864_();
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, -2, 0, 0.0f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, -2, 0, 0.5f, 0.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), 1, 2, 0, 0.5f, 1.0f, 0, 1, 0, 240);
                this.drawVertex(matrix4f, matrix3f, ivertexbuilder, i, (int)(alphaForRender * 255.0f), -1, 2, 0, 0.0f, 1.0f, 0, 1, 0, 240);
                matrixStackIn.m_85849_();
                matrixStackIn.m_85849_();
            } else {
                ((ModelGhost)this.f_115290_).m_7695_(matrixStackIn, ivertexbuilder, 240, i, 1.0f, 1.0f, 1.0f, alphaForRender);
            }
        }
        if (!entityIn.m_5833_()) {
            for (RenderLayer layerrenderer : this.f_115291_) {
                layerrenderer.m_6494_(matrixStackIn, bufferIn, packedLightIn, (Entity)entityIn, f5, f8, partialTicks, f7, f2, f6);
            }
        }
        matrixStackIn.m_85849_();
        RenderNameplateEvent renderNameplateEvent = new RenderNameplateEvent((Entity)entityIn, entityIn.m_5446_(), (EntityRenderer)this, matrixStackIn, bufferIn, packedLightIn, partialTicks);
        MinecraftForge.EVENT_BUS.post((Event)renderNameplateEvent);
        if (renderNameplateEvent.getResult() != Event.Result.DENY && (renderNameplateEvent.getResult() == Event.Result.ALLOW || this.m_6512_((Mob)entityIn))) {
            this.m_7649_((Entity)entityIn, renderNameplateEvent.getContent(), matrixStackIn, bufferIn, packedLightIn);
        }
        MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post((LivingEntity)entityIn, (LivingEntityRenderer)this, partialTicks, matrixStackIn, bufferIn, packedLightIn));
    }

    protected float getFlipDegrees(@NotNull EntityGhost ghost) {
        return 0.0f;
    }

    public float getAlphaForRender(EntityGhost entityIn, float partialTicks) {
        if (entityIn.isDaytimeMode()) {
            return Mth.m_14036_((float)((float)(101 - Math.min(entityIn.getDaytimeCounter(), 100)) / 100.0f), (float)0.0f, (float)1.0f);
        }
        return Mth.m_14036_((float)((Mth.m_14031_((float)(((float)entityIn.f_19797_ + partialTicks) * 0.1f)) + 1.0f) * 0.5f + 0.1f), (float)0.0f, (float)1.0f);
    }

    public void scale(@NotNull EntityGhost LivingEntityIn, @NotNull PoseStack stack, float partialTickTime) {
    }

    @NotNull
    public ResourceLocation getTextureLocation(EntityGhost ghost) {
        switch (ghost.getColor()) {
            case 1: {
                return TEXTURE_1;
            }
            case 2: {
                return TEXTURE_2;
            }
            case -1: {
                return TEXTURE_SHOPPING_LIST;
            }
        }
        return TEXTURE_0;
    }

    public void drawVertex(Matrix4f stack, Matrix3f normal, VertexConsumer builder, int packedRed, int alphaInt, int x, int y, int z, float u, float v, int lightmap, int lightmap3, int lightmap2, int lightmap4) {
        builder.m_85982_(stack, (float)x, (float)y, (float)z).m_6122_(255, 255, 255, alphaInt).m_7421_(u, v).m_86008_(packedRed).m_85969_(lightmap4).m_85977_(normal, (float)lightmap, (float)lightmap2, (float)lightmap3).m_5752_();
    }
}

